/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.tree.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.TreeType;

@Beta
public final class DataTreeConfiguration
implements Immutable {
    public static final @NonNull DataTreeConfiguration DEFAULT_CONFIGURATION = new Builder(TreeType.CONFIGURATION).setMandatoryNodesValidation(true).build();
    public static final @NonNull DataTreeConfiguration DEFAULT_OPERATIONAL = new Builder(TreeType.OPERATIONAL).setMandatoryNodesValidation(true).build();
    private final @NonNull TreeType treeType;
    private final @NonNull YangInstanceIdentifier rootPath;
    private final boolean uniqueIndexes;
    private final boolean mandatoryNodesValidation;
    private final boolean trackVersionInfo;
    private final boolean recursiveWriteValidation;

    DataTreeConfiguration(TreeType treeType, YangInstanceIdentifier rootPath, boolean uniqueIndexes, boolean mandatoryNodesValidation, boolean trackVersionInfo, boolean recursiveWriteValidation) {
        this.treeType = Objects.requireNonNull(treeType);
        this.rootPath = Objects.requireNonNull(rootPath);
        this.uniqueIndexes = uniqueIndexes;
        this.mandatoryNodesValidation = mandatoryNodesValidation;
        this.trackVersionInfo = trackVersionInfo;
        this.recursiveWriteValidation = recursiveWriteValidation;
    }

    public static @NonNull DataTreeConfiguration getDefault(TreeType treeType) {
        return switch (Objects.requireNonNull(treeType)) {
            default -> throw new MatchException(null, null);
            case TreeType.CONFIGURATION -> DEFAULT_CONFIGURATION;
            case TreeType.OPERATIONAL -> DEFAULT_OPERATIONAL;
        };
    }

    public static @NonNull Builder builder(TreeType treeType) {
        return new Builder(treeType);
    }

    @Deprecated(since="14.0.14", forRemoval=true)
    public @NonNull Builder copyBuilder() {
        return this.toBuilder();
    }

    public @NonNull Builder toBuilder() {
        return new Builder(this.treeType).setMandatoryNodesValidation(this.isMandatoryNodesValidationEnabled()).setRecursiveWriteValidation(this.isRecursiveWriteValidationEnabled()).setRootPath(this.getRootPath()).setUniqueIndexes(this.isUniqueIndexEnabled()).setTrackVersionInfo(this.isVersionInfoTrackingEnabled());
    }

    public @NonNull YangInstanceIdentifier getRootPath() {
        return this.rootPath;
    }

    public @NonNull TreeType getTreeType() {
        return this.treeType;
    }

    public boolean isMandatoryNodesValidationEnabled() {
        return this.mandatoryNodesValidation;
    }

    public boolean isUniqueIndexEnabled() {
        return this.uniqueIndexes;
    }

    public boolean isVersionInfoTrackingEnabled() {
        return this.trackVersionInfo;
    }

    public boolean isRecursiveWriteValidationEnabled() {
        return this.recursiveWriteValidation;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.treeType, this.rootPath, this.uniqueIndexes, this.mandatoryNodesValidation, this.trackVersionInfo, this.recursiveWriteValidation});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof DataTreeConfiguration)) return false;
        DataTreeConfiguration other = (DataTreeConfiguration)obj;
        if (this.treeType != other.treeType) return false;
        if (!this.rootPath.equals((Object)other.rootPath)) return false;
        if (this.uniqueIndexes != other.uniqueIndexes) return false;
        if (this.mandatoryNodesValidation != other.mandatoryNodesValidation) return false;
        if (this.trackVersionInfo != other.trackVersionInfo) return false;
        if (this.recursiveWriteValidation != other.recursiveWriteValidation) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.treeType).add("root", (Object)this.rootPath).add("mandatory", this.mandatoryNodesValidation).add("unique", this.uniqueIndexes).add("info", this.trackVersionInfo).add("recursive", this.recursiveWriteValidation).toString();
    }

    public static class Builder
    implements Mutable {
        private final TreeType treeType;
        private YangInstanceIdentifier rootPath = YangInstanceIdentifier.of();
        private boolean uniqueIndexes;
        private boolean mandatoryNodesValidation;
        private boolean trackVersionInfo;
        private boolean recursiveWriteValidation;

        @Deprecated(since="14.0.14", forRemoval=true)
        public Builder(TreeType treeType) {
            this.treeType = Objects.requireNonNull(treeType);
            this.recursiveWriteValidation = treeType == TreeType.CONFIGURATION;
        }

        public @NonNull Builder setUniqueIndexes(boolean uniqueIndexes) {
            this.uniqueIndexes = uniqueIndexes;
            return this;
        }

        public @NonNull Builder setMandatoryNodesValidation(boolean mandatoryNodesValidation) {
            this.mandatoryNodesValidation = mandatoryNodesValidation;
            return this;
        }

        public @NonNull Builder setRootPath(YangInstanceIdentifier rootPath) {
            this.rootPath = rootPath.toOptimized();
            return this;
        }

        public @NonNull Builder setTrackVersionInfo(boolean trackVersionInfo) {
            this.trackVersionInfo = trackVersionInfo;
            return this;
        }

        public @NonNull Builder setRecursiveWriteValidation(boolean recursiveWriteValidation) {
            this.recursiveWriteValidation = recursiveWriteValidation;
            return this;
        }

        public @NonNull DataTreeConfiguration build() {
            return new DataTreeConfiguration(this.treeType, this.rootPath, this.uniqueIndexes, this.mandatoryNodesValidation, this.trackVersionInfo, this.recursiveWriteValidation);
        }
    }
}

