/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.spi.node.impl;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AbstractLeafNode;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ImmutableLeafNode<T>
extends AbstractLeafNode<T> {
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull YangInstanceIdentifier.NodeIdentifier name;
    private final @NonNull T value;

    private ImmutableLeafNode(YangInstanceIdentifier.NodeIdentifier name, T value) {
        this.name = Objects.requireNonNull(name);
        this.value = Objects.requireNonNull(value);
    }

    public static <T> @NonNull ImmutableLeafNode<T> of(YangInstanceIdentifier.NodeIdentifier identifier, T value) {
        YangInstanceIdentifier yiid;
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            Binary ret = new Binary(identifier, bytes);
            return ret;
        }
        if (value instanceof YangInstanceIdentifier && (yiid = (YangInstanceIdentifier)value).isEmpty()) {
            throw new IllegalArgumentException("Leaf node value cannot be an empty instance identifier");
        }
        return new Regular<T>(identifier, value);
    }

    public final YangInstanceIdentifier.NodeIdentifier name() {
        return this.name;
    }

    protected final T value() {
        return this.value;
    }

    protected final Class<?> toStringClass() {
        return ImmutableLeafNode.class;
    }

    private static final class Binary
    extends ImmutableLeafNode<byte[]> {
        Binary(YangInstanceIdentifier.NodeIdentifier name, byte[] value) {
            super(name, value);
        }

        protected byte[] wrappedValue() {
            return (byte[])((byte[])this.value()).clone();
        }
    }

    private static final class Regular<T>
    extends ImmutableLeafNode<T> {
        Regular(YangInstanceIdentifier.NodeIdentifier name, T value) {
            super(name, value);
        }

        protected T wrappedValue() {
            return this.value();
        }
    }
}

