/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeWriter;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaTreeInference;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

public class SchemaOrderedNormalizedNodeWriter
extends NormalizedNodeWriter {
    private final EffectiveModelContext modelContext;
    private final SchemaNode root;
    private SchemaNode currentSchemaNode;

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, EffectiveModelContext modelContext) {
        super(writer);
        this.modelContext = Objects.requireNonNull(modelContext);
        this.root = this.modelContext;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, SchemaInferenceStack stack) {
        super(writer);
        this.modelContext = stack.modelContext();
        if (!stack.isEmpty()) {
            SchemaNode schemaNode;
            EffectiveStatement current = stack.currentStatement();
            if (!(current instanceof SchemaNode)) throw new IllegalArgumentException("Instantiating at " + String.valueOf(current) + " is not supported");
            this.root = schemaNode = (SchemaNode)current;
            return;
        } else {
            this.root = this.modelContext;
        }
    }

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, EffectiveModelContext schemaContext, SchemaNodeIdentifier.Absolute path) {
        this(writer, SchemaInferenceStack.of((EffectiveModelContext)schemaContext, (SchemaNodeIdentifier.Absolute)path));
    }

    public SchemaOrderedNormalizedNodeWriter(NormalizedNodeStreamWriter writer, SchemaTreeInference rootInference) {
        this(writer, SchemaInferenceStack.ofInference((SchemaTreeInference)rootInference));
    }

    public SchemaOrderedNormalizedNodeWriter write(NormalizedNode node) throws IOException {
        this.currentSchemaNode = this.modelContext.equals((Object)this.root) ? this.modelContext.dataChildByName(node.name().getNodeType()) : this.root;
        return this.write(node, this.currentSchemaNode);
    }

    public SchemaOrderedNormalizedNodeWriter write(Collection<DataContainerChild> nodes) throws IOException {
        this.currentSchemaNode = this.root;
        if (this.writeChildren(nodes, this.currentSchemaNode, false)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize nodes " + String.valueOf(nodes));
    }

    private SchemaOrderedNormalizedNodeWriter write(NormalizedNode node, SchemaNode dataSchemaNode) throws IOException {
        try (SchemaNodeSetter sns = new SchemaNodeSetter(dataSchemaNode);){
            if (node == null) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
            if (this.wasProcessedAsCompositeNode(node)) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
            if (this.wasProcessAsSimpleNode(node)) {
                SchemaOrderedNormalizedNodeWriter schemaOrderedNormalizedNodeWriter = this;
                return schemaOrderedNormalizedNodeWriter;
            }
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + String.valueOf(node));
    }

    private void write(Collection<NormalizedNode> nodes, SchemaNode dataSchemaNode) throws IOException {
        for (NormalizedNode node : nodes) {
            this.write(node, dataSchemaNode);
        }
    }

    protected boolean writeChildren(Iterable<? extends NormalizedNode> children) throws IOException {
        return this.writeChildren(children, this.currentSchemaNode, true);
    }

    private boolean writeChildren(Iterable<? extends NormalizedNode> children, SchemaNode parentSchemaNode, boolean endParent) throws IOException {
        ArrayListMultimap qnameToNodes = ArrayListMultimap.create();
        for (NormalizedNode normalizedNode : children) {
            SchemaOrderedNormalizedNodeWriter.putChild((Multimap<QName, NormalizedNode>)qnameToNodes, normalizedNode);
        }
        if (parentSchemaNode instanceof DataNodeContainer) {
            DataNodeContainer parentContainer = (DataNodeContainer)parentSchemaNode;
            if (parentContainer instanceof ListSchemaNode && qnameToNodes.containsKey((Object)parentSchemaNode.getQName())) {
                this.write(qnameToNodes.get((Object)parentSchemaNode.getQName()), parentSchemaNode);
            } else {
                for (DataSchemaNode dataSchemaNode : parentContainer.getChildNodes()) {
                    this.write(qnameToNodes.get((Object)dataSchemaNode.getQName()), (SchemaNode)dataSchemaNode);
                }
            }
        } else if (parentSchemaNode instanceof ChoiceSchemaNode) {
            ChoiceSchemaNode choiceSchemaNode = (ChoiceSchemaNode)parentSchemaNode;
            for (CaseSchemaNode caseSchemaNode : choiceSchemaNode.getCases()) {
                for (DataSchemaNode childCaseChild : caseSchemaNode.getChildNodes()) {
                    Collection node = (Collection)qnameToNodes.asMap().get(childCaseChild.getQName());
                    if (node == null) continue;
                    this.write(node, (SchemaNode)childCaseChild);
                }
            }
        } else {
            for (NormalizedNode normalizedNode : children) {
                this.writeLeaf(normalizedNode);
            }
        }
        if (endParent) {
            this.getWriter().endNode();
        }
        return true;
    }

    private SchemaOrderedNormalizedNodeWriter writeLeaf(NormalizedNode node) throws IOException {
        if (this.wasProcessAsSimpleNode(node)) {
            return this;
        }
        throw new IllegalStateException("It wasn't possible to serialize node " + String.valueOf(node));
    }

    private static void putChild(Multimap<QName, NormalizedNode> qnameToNodes, NormalizedNode child) {
        qnameToNodes.put((Object)child.name().getNodeType(), (Object)child);
    }

    private final class SchemaNodeSetter
    implements AutoCloseable {
        private final SchemaNode previousSchemaNode;

        SchemaNodeSetter(SchemaNode schemaNode) {
            this.previousSchemaNode = SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode;
            SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode = schemaNode;
        }

        @Override
        public void close() {
            SchemaOrderedNormalizedNodeWriter.this.currentSchemaNode = this.previousSchemaNode;
        }
    }
}

