/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.schema.nodes;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.DataContainerChild;
import org.opendaylight.yangtools.yang.data.api.schema.LeafNode;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;

@Beta
public final class LazyLeafOperations {
    private LazyLeafOperations() {
    }

    public static @Nullable DataContainerChild getChild(Map<YangInstanceIdentifier.PathArgument, Object> map, YangInstanceIdentifier.PathArgument key) {
        Object value = map.get(key);
        return value == null ? null : LazyLeafOperations.decodeChild(key, value);
    }

    public static void putChild(Map<YangInstanceIdentifier.PathArgument, Object> map, DataContainerChild child) {
        DataContainerChild node = Objects.requireNonNull(child);
        map.put(node.getIdentifier(), LazyLeafOperations.encodeExpendableChild(node));
    }

    static @NonNull LeafNode<?> coerceLeaf(YangInstanceIdentifier.PathArgument key, Object value) {
        Verify.verify((boolean)(key instanceof YangInstanceIdentifier.NodeIdentifier), (String)"Unexpected value %s for child %s", (Object)value, (Object)key);
        return ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)key, value);
    }

    private static @Nullable DataContainerChild decodeChild(YangInstanceIdentifier.PathArgument key, @NonNull Object value) {
        return LazyLeafOperations.decodeExpendableChild(key, value);
    }

    private static @NonNull DataContainerChild decodeExpendableChild(YangInstanceIdentifier.PathArgument key, @NonNull Object value) {
        return value instanceof DataContainerChild ? (LeafNode<?>)value : LazyLeafOperations.coerceLeaf(key, value);
    }

    private static @NonNull Object encodeExpendableChild(@NonNull DataContainerChild node) {
        return node instanceof LeafNode ? LazyLeafOperations.verifyEncode(((LeafNode)node).body()) : node;
    }

    private static @NonNull Object verifyEncode(@NonNull Object value) {
        Verify.verify((!(value instanceof DataContainerChild) ? 1 : 0) != 0, (String)"Unexpected leaf value %s", (Object)value);
        return value;
    }
}

