/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.impl.codec;

import com.google.common.annotations.Beta;
import com.google.common.collect.RangeSet;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.codec.DecimalCodec;
import org.opendaylight.yangtools.yang.data.api.codec.YangInvalidValueException;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;

@Beta
public final class DecimalStringCodec
extends TypeDefinitionAwareCodec<Decimal64, DecimalTypeDefinition>
implements DecimalCodec<String> {
    private DecimalStringCodec(DecimalTypeDefinition typeDef) {
        super(Objects.requireNonNull(typeDef), Decimal64.class);
    }

    public static @NonNull DecimalStringCodec from(DecimalTypeDefinition type) {
        return new DecimalStringCodec(type);
    }

    protected Decimal64 deserializeImpl(String product) {
        Decimal64 value;
        DecimalTypeDefinition typeDef = (DecimalTypeDefinition)this.getTypeDefinition().orElseThrow();
        Decimal64 parsed = Decimal64.valueOf((String)product);
        try {
            value = parsed.scaleTo(typeDef.getFractionDigits());
        }
        catch (ArithmeticException e) {
            throw new IllegalArgumentException("Value '" + product + "' does not match required fraction-digits", e);
        }
        typeDef.getRangeConstraint().ifPresent(constraint -> {
            RangeSet ranges = constraint.getAllowedRanges();
            if (!ranges.contains((Comparable)value)) {
                throw new YangInvalidValueException(ErrorType.APPLICATION, (ConstraintMetaDefinition)constraint, "Value '" + value + "' is not in required ranges " + ranges);
            }
        });
        return value;
    }

    protected String serializeImpl(Decimal64 input) {
        return input.toString();
    }
}

