/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;

abstract sealed class PreferredPrefixes {
    private PreferredPrefixes() {
    }

    abstract @Nullable String prefixForNamespace(@NonNull XMLNamespace var1);

    abstract boolean isUsed(String var1);

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mappings", this.mappings()).toString();
    }

    abstract Map<XMLNamespace, ?> mappings();

    static final class Shared
    extends PreferredPrefixes {
        private final ConcurrentMap<XMLNamespace, Optional<String>> mappings = new ConcurrentHashMap<XMLNamespace, Optional<String>>();
        private final EffectiveModelContext modelContext;

        Shared(EffectiveModelContext modelContext) {
            this.modelContext = Objects.requireNonNull(modelContext);
        }

        @Override
        String prefixForNamespace(XMLNamespace namespace) {
            Optional existing = (Optional)this.mappings.get(namespace);
            if (existing != null) {
                return existing.orElse(null);
            }
            Iterator modules = this.modelContext.findModuleStatements(namespace).iterator();
            return modules.hasNext() ? this.loadPrefix(namespace, (String)((ModuleEffectiveStatement)modules.next()).prefix().argument()) : null;
        }

        @Override
        boolean isUsed(String prefix) {
            return this.modulesForPrefix(prefix).findAny().isPresent();
        }

        @NonNull PreferredPrefixes toPrecomputed() {
            for (ModuleEffectiveStatement module : this.modelContext.getModuleStatements().values()) {
                this.prefixForNamespace((XMLNamespace)module.namespace().argument());
            }
            return new Precomputed(Maps.transformValues((Map)Maps.filterValues(this.mappings, Optional::isPresent), Optional::orElseThrow));
        }

        @Override
        Map<XMLNamespace, ?> mappings() {
            return this.mappings;
        }

        private @Nullable String loadPrefix(XMLNamespace namespace, String prefix) {
            Optional<Object> mapping = this.isValidMapping(namespace, prefix) ? Optional.of(prefix) : Optional.empty();
            Optional<Object> raced = this.mappings.putIfAbsent(namespace, mapping);
            return (raced != null ? raced : mapping).orElse(null);
        }

        private boolean isValidMapping(XMLNamespace namespace, String prefix) {
            return !Shared.startsWithXml(prefix) && this.modulesForPrefix(prefix).allMatch(module -> namespace.equals(module.namespace().argument()));
        }

        private Stream<ModuleEffectiveStatement> modulesForPrefix(String prefix) {
            return this.modelContext.getModuleStatements().values().stream().filter(module -> prefix.equals(module.prefix().argument()));
        }

        private static boolean startsWithXml(String prefix) {
            if (prefix.length() < 3) {
                return false;
            }
            char first = prefix.charAt(0);
            if (first != 'x' && first != 'X') {
                return false;
            }
            char second = prefix.charAt(1);
            if (second != 'm' && second != 'M') {
                return false;
            }
            char third = prefix.charAt(2);
            return third == 'l' || third == 'L';
        }
    }

    static final class Precomputed
    extends PreferredPrefixes {
        private final ImmutableBiMap<XMLNamespace, String> mappings;

        Precomputed(Map<XMLNamespace, String> mappings) {
            this.mappings = ImmutableBiMap.copyOf(mappings);
        }

        @Override
        String prefixForNamespace(XMLNamespace namespace) {
            return (String)this.mappings.get((Object)namespace);
        }

        @Override
        boolean isUsed(String prefix) {
            return this.mappings.inverse().containsKey((Object)prefix);
        }

        @Override
        Map<XMLNamespace, ?> mappings() {
            return this.mappings;
        }
    }
}

