/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.codec.xml.DOMSourceXMLStreamReader;
import org.opendaylight.yangtools.yang.data.codec.xml.NamespacePrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementInference;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StreamWriterFacade
extends ValueWriter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamWriterFacade.class);
    private static final Set<String> BROKEN_NAMESPACES = ConcurrentHashMap.newKeySet();
    private static final Set<String> LEGACY_ATTRIBUTES = ConcurrentHashMap.newKeySet();
    private final XMLStreamWriter writer;
    private final NamespacePrefixes prefixes;
    private QName openElement;

    StreamWriterFacade(XMLStreamWriter writer, @Nullable PreferredPrefixes pref) {
        this.writer = Objects.requireNonNull(writer);
        this.prefixes = new NamespacePrefixes(writer.getNamespaceContext(), pref);
    }

    void writeCharacters(String text) throws XMLStreamException {
        if (!Strings.isNullOrEmpty((String)text)) {
            this.flushElement();
            this.writer.writeCharacters(text);
        }
    }

    @Override
    void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.flushElement();
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    @Override
    void writeAttribute(String localName, String value) throws XMLStreamException {
        this.flushElement();
        this.writer.writeAttribute(localName, value);
    }

    @Override
    void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.flushElement();
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    private void flushElement() throws XMLStreamException {
        if (this.openElement != null) {
            this.writer.writeStartElement("", this.openElement.getLocalName(), this.openElement.getNamespace().toString());
            this.openElement = null;
        }
    }

    void writeStartElement(QName qname) throws XMLStreamException {
        this.flushElement();
        String namespace = qname.getNamespace().toString();
        NamespaceContext context = this.writer.getNamespaceContext();
        boolean reuseNamespace = context != null ? namespace.equals(context.getNamespaceURI("")) : "".equals(this.writer.getPrefix(namespace));
        if (!reuseNamespace) {
            this.writer.writeStartElement("", qname.getLocalName(), namespace);
            this.writer.writeDefaultNamespace(namespace);
        } else {
            this.openElement = qname;
        }
    }

    void writeEndElement() throws XMLStreamException {
        if (this.openElement != null) {
            this.writer.writeEmptyElement("", this.openElement.getLocalName(), this.openElement.getNamespace().toString());
            this.openElement = null;
        } else {
            this.writer.writeEndElement();
        }
    }

    String getPrefix(XMLNamespace uri, String str) throws XMLStreamException {
        String prefix = this.writer.getPrefix(str);
        if (prefix != null) {
            return prefix;
        }
        if (BROKEN_NAMESPACES.add(str)) {
            LOG.info("Namespace {} was not bound, please fix the caller", (Object)str, (Object)new Throwable());
        }
        return this.prefixes.encodePrefix(uri);
    }

    void close() throws XMLStreamException {
        XMLStreamException failure = null;
        try {
            this.flushElement();
        }
        catch (XMLStreamException e) {
            failure = e;
            throw e;
        }
        finally {
            try {
                this.writer.close();
            }
            catch (XMLStreamException e) {
                if (failure != null) {
                    failure.addSuppressed(e);
                }
                throw e;
            }
        }
    }

    void flush() throws XMLStreamException {
        this.flushElement();
        this.writer.flush();
    }

    void anydataWriteStreamReader(XMLStreamReader reader) throws XMLStreamException {
        this.flushElement();
        int depth = 0;
        block10: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (depth != 0) {
                        this.forwardStartElement(reader);
                    } else {
                        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                            String prefix = reader.getNamespacePrefix(i);
                            if ("".equals(prefix)) continue;
                            this.writer.writeNamespace(prefix, reader.getNamespaceURI(i));
                        }
                    }
                    ++depth;
                    continue block10;
                }
                case 2: {
                    if (--depth == 0) continue block10;
                    this.writer.writeEndElement();
                    continue block10;
                }
                case 4: {
                    this.writer.writeCharacters(reader.getText());
                    continue block10;
                }
                case 5: 
                case 6: {
                    continue block10;
                }
                case 7: 
                case 8: {
                    continue block10;
                }
                case 10: {
                    this.forwardAttributes(reader);
                    continue block10;
                }
                case 12: {
                    this.writer.writeCData(reader.getText());
                    continue block10;
                }
                case 13: {
                    this.forwardNamespaces(reader);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unhandled event " + event);
        }
    }

    void anyxmlWriteStreamReader(DOMSourceXMLStreamReader reader) throws XMLStreamException {
        this.flushElement();
        int depth = 0;
        block14: while (reader.hasNext()) {
            int event = reader.next();
            switch (event) {
                case 1: {
                    if (depth != 0) {
                        this.forwardStartElement((XMLStreamReader)((Object)reader));
                    } else {
                        this.forwardNamespaces((XMLStreamReader)((Object)reader));
                        this.forwardAttributes((XMLStreamReader)((Object)reader));
                    }
                    ++depth;
                    continue block14;
                }
                case 2: {
                    if (--depth == 0) continue block14;
                    this.writer.writeEndElement();
                    continue block14;
                }
                case 3: {
                    this.forwardProcessingInstruction((XMLStreamReader)((Object)reader));
                    continue block14;
                }
                case 4: {
                    this.writer.writeCharacters(reader.getText());
                    continue block14;
                }
                case 5: {
                    this.writer.writeComment(reader.getText());
                    continue block14;
                }
                case 6: {
                    continue block14;
                }
                case 7: 
                case 8: {
                    continue block14;
                }
                case 9: {
                    this.writer.writeEntityRef(reader.getLocalName());
                    continue block14;
                }
                case 10: {
                    this.forwardAttributes((XMLStreamReader)((Object)reader));
                    continue block14;
                }
                case 11: {
                    this.writer.writeDTD(reader.getText());
                    continue block14;
                }
                case 12: {
                    this.writer.writeCData(reader.getText());
                    continue block14;
                }
                case 13: {
                    this.forwardNamespaces((XMLStreamReader)((Object)reader));
                    continue block14;
                }
            }
            throw new IllegalStateException("Unhandled event " + event);
        }
    }

    void emitNormalizedAnydata(NormalizedAnydata anydata) throws XMLStreamException {
        SchemaInferenceStack.Inference inference;
        this.flushElement();
        try {
            SchemaInferenceStack stack = SchemaInferenceStack.ofInference((EffectiveStatementInference)anydata.getInference());
            stack.exitToDataTree();
            inference = stack.toInference();
        }
        catch (IllegalArgumentException | IllegalStateException | NoSuchElementException e) {
            throw new XMLStreamException("Cannot emit " + anydata, e);
        }
        try {
            anydata.writeTo(XMLStreamNormalizedNodeStreamWriter.create(this.writer, (EffectiveStatementInference)inference));
        }
        catch (IOException e) {
            throw new XMLStreamException("Failed to emit anydata " + anydata, e);
        }
    }

    static void warnLegacyAttribute(String localName) {
        if (LEGACY_ATTRIBUTES.add(localName)) {
            LOG.info("Encountered annotation {} not bound to module. Please examine the call stack and fix this warning by defining a proper YANG annotation to cover it", (Object)localName, (Object)new Throwable("Call stack"));
        }
    }

    private void forwardAttributes(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String localName = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            String prefix = reader.getAttributePrefix(i);
            if (prefix != null) {
                this.writer.writeAttribute(prefix, reader.getAttributeNamespace(i), localName, value);
                continue;
            }
            this.writer.writeAttribute(localName, value);
        }
    }

    private void forwardNamespaces(XMLStreamReader reader) throws XMLStreamException {
        for (int i = 0; i < reader.getNamespaceCount(); ++i) {
            this.writer.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
        }
    }

    private void forwardProcessingInstruction(XMLStreamReader reader) throws XMLStreamException {
        String target = reader.getPITarget();
        String data = reader.getPIData();
        if (data != null) {
            this.writer.writeProcessingInstruction(target, data);
        } else {
            this.writer.writeProcessingInstruction(target);
        }
    }

    private void forwardStartElement(XMLStreamReader reader) throws XMLStreamException {
        String localName = reader.getLocalName();
        String prefix = reader.getPrefix();
        if (prefix != null) {
            this.writer.writeStartElement(prefix, localName, reader.getNamespaceURI());
        } else {
            this.writer.writeStartElement(localName);
        }
        this.forwardNamespaces(reader);
        this.forwardAttributes(reader);
    }
}

