/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.codec.xml.InstanceIdentifierSerializer;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;
import org.opendaylight.yangtools.yang.data.codec.xml.ValueWriter;
import org.opendaylight.yangtools.yang.data.codec.xml.XMLStreamWriterUtils;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

final class SchemaAwareXMLStreamWriterUtils
extends XMLStreamWriterUtils {
    private final @NonNull EffectiveModelContext modelContext;
    private final @Nullable PreferredPrefixes pref;

    SchemaAwareXMLStreamWriterUtils(EffectiveModelContext modelContext, @Nullable PreferredPrefixes pref) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.pref = pref;
    }

    @NonNull EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    @Override
    String encodeInstanceIdentifier(ValueWriter writer, YangInstanceIdentifier value) throws XMLStreamException {
        InstanceIdentifierSerializer serializer = new InstanceIdentifierSerializer(DataSchemaContextTree.from((EffectiveModelContext)this.modelContext), writer.getNamespaceContext(), this.pref);
        String str = (String)serializer.serialize(value);
        for (Map.Entry<XMLNamespace, String> entry : serializer.emittedPrefixes()) {
            writer.writeNamespace(entry.getValue(), entry.getKey().toString());
        }
        return str;
    }
}

