/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.xml;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.XMLNamespace;
import org.opendaylight.yangtools.yang.data.codec.xml.PreferredPrefixes;

final class NamespacePrefixes
implements Mutable {
    @VisibleForTesting
    static final String LOOKUP = "abcdefghiknoprstABCDEFGHIKNOPRST";
    @VisibleForTesting
    static final int SHIFT = 5;
    private static final int MASK = 31;
    private int counter = 0;
    private final BiMap<XMLNamespace, String> emittedPrefixes = HashBiMap.create();
    private final PreferredPrefixes pref;
    private final NamespaceContext context;

    NamespacePrefixes(NamespaceContext context, @Nullable PreferredPrefixes pref) {
        this.context = context;
        this.pref = pref;
    }

    List<Map.Entry<XMLNamespace, String>> emittedPrefixes() {
        return this.emittedPrefixes.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getValue)).collect(Collectors.toList());
    }

    @NonNull String encodePrefix(XMLNamespace namespace) {
        String prefix = (String)this.emittedPrefixes.get((Object)namespace);
        if (prefix != null) {
            return prefix;
        }
        if (this.context != null && (prefix = this.context.getPrefix(namespace.toString())) != null) {
            return prefix;
        }
        prefix = this.createPrefix(namespace);
        this.emittedPrefixes.put((Object)namespace, (Object)prefix);
        return prefix;
    }

    private @NonNull String createPrefix(@NonNull XMLNamespace namespace) {
        String prefix;
        if (this.pref != null && (prefix = this.pref.prefixForNamespace(namespace)) != null) {
            return prefix;
        }
        while (this.alreadyUsedPrefix(prefix = NamespacePrefixes.encode(this.counter++))) {
        }
        return prefix;
    }

    private boolean alreadyUsedPrefix(String prefix) {
        if (this.pref != null && this.pref.isUsed(prefix)) {
            return true;
        }
        if (this.context == null) {
            return false;
        }
        String str = this.context.getNamespaceURI(prefix);
        return str != null && !"".equals(str);
    }

    @VisibleForTesting
    static @NonNull String encode(int num) {
        StringBuilder sb = new StringBuilder();
        do {
            sb.append(LOOKUP.charAt(num & 0x1F));
        } while ((num >>>= 5) != 0);
        return sb.reverse().toString();
    }
}

