/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.codec.gson;

import com.google.common.base.Preconditions;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.codec.gson.JSONCodec;
import org.opendaylight.yangtools.yang.data.util.codec.IdentityCodecUtil;
import org.opendaylight.yangtools.yang.data.util.codec.QNameCodecUtil;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;

final class IdentityrefJSONCodec
implements JSONCodec<QName> {
    private final @NonNull EffectiveModelContext context;
    private final @NonNull QNameModule parentModule;

    IdentityrefJSONCodec(EffectiveModelContext context, QNameModule parentModule) {
        this.context = Objects.requireNonNull(context);
        this.parentModule = Objects.requireNonNull(parentModule);
    }

    public Class<QName> getDataType() {
        return QName.class;
    }

    public QName parseValue(Object ctx, String value) {
        return IdentityCodecUtil.parseIdentity((String)value, (EffectiveModelContext)this.context, prefix -> {
            if (prefix.isEmpty()) {
                return this.parentModule;
            }
            Iterator modules = this.context.findModules(prefix).iterator();
            Preconditions.checkArgument((boolean)modules.hasNext(), (String)"Could not find module %s", (Object)prefix);
            return ((Module)modules.next()).getQNameModule();
        }).getQName();
    }

    @Override
    public void writeValue(JsonWriter writer, QName value) throws IOException {
        String str = QNameCodecUtil.encodeQName((QName)value, uri -> this.context.findModule(uri).map(ModuleLike::getName).orElseThrow(() -> new IllegalArgumentException("Cannot find module for " + uri)));
        writer.value(str);
    }
}

