/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.ImmutableYangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangNetconfErrorAware;

public final class NormalizationException
extends Exception
implements YangNetconfErrorAware {
    private static final long serialVersionUID = 1L;
    private final @NonNull List<@NonNull YangNetconfError> netconfErrors;

    private NormalizationException(Throwable cause) {
        super(cause);
        this.netconfErrors = NormalizationException.constructErrors(this.getMessage());
    }

    private NormalizationException(String message, Throwable cause, List<@NonNull YangNetconfError> netconfErrors) {
        super(message, cause);
        this.netconfErrors = Objects.requireNonNull(netconfErrors);
    }

    public static @NonNull NormalizationException ofMessage(String message) {
        return new NormalizationException(Objects.requireNonNull(message), null, NormalizationException.constructErrors(message));
    }

    public static @NonNull NormalizationException ofCause(Throwable cause) {
        YangNetconfErrorAware aware;
        List<YangNetconfError> errors;
        if (cause instanceof YangNetconfErrorAware && !(errors = (aware = (YangNetconfErrorAware)((Object)cause)).getNetconfErrors()).isEmpty()) {
            return new NormalizationException(cause.getMessage(), cause, List.copyOf(errors));
        }
        return new NormalizationException(cause);
    }

    @Override
    public List<@NonNull YangNetconfError> getNetconfErrors() {
        return this.netconfErrors;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        NormalizationException.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        NormalizationException.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        NormalizationException.throwNSE();
    }

    private static @NonNull List<@NonNull YangNetconfError> constructErrors(@NonNull String message) {
        return List.of(ImmutableYangNetconfError.builder().severity(ErrorSeverity.ERROR).type(ErrorType.PROTOCOL).tag(ErrorTag.MALFORMED_MESSAGE).message(message).build());
    }

    private static void throwNSE() throws NotSerializableException {
        throw new NotSerializableException(NormalizationException.class.getName());
    }
}

