/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.codec;

import com.google.common.annotations.Beta;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.data.api.ImmutableYangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangNetconfError;
import org.opendaylight.yangtools.yang.data.api.YangNetconfErrorAware;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;

@Beta
public class YangInvalidValueException
extends IllegalArgumentException
implements YangNetconfErrorAware {
    private static final long serialVersionUID = 1L;
    private final @NonNull ErrorType errorType;
    private final @Nullable String errorAppTag;
    private final @Nullable String errorMessage;

    public YangInvalidValueException(ErrorType errorType, ConstraintMetaDefinition constraint, String message) {
        super(Objects.requireNonNull(message));
        this.errorType = Objects.requireNonNull(errorType);
        this.errorAppTag = constraint.getErrorAppTag().orElse(null);
        this.errorMessage = constraint.getErrorMessage().orElse(null);
    }

    @Override
    public List<YangNetconfError> getNetconfErrors() {
        return List.of(ImmutableYangNetconfError.builder().severity(ErrorSeverity.ERROR).type(this.errorType).tag(ErrorTag.INVALID_VALUE).message(this.errorMessage).appTag(this.errorAppTag).build());
    }
}

