/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.stream;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedAnydata;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public final class YangInstanceIdentifierWriter
implements AutoCloseable {
    private NormalizedNodeStreamWriter writer;
    private final int endNodeCount;

    private YangInstanceIdentifierWriter(NormalizedNodeStreamWriter writer, int endNodeCount) {
        this.writer = Objects.requireNonNull(writer);
        this.endNodeCount = endNodeCount;
    }

    public static @NonNull YangInstanceIdentifierWriter open(NormalizedNodeStreamWriter writer, DataNodeContainer root, YangInstanceIdentifier path) throws IOException {
        Iterator<YangInstanceIdentifier.PathArgument> it = path.getPathArguments().iterator();
        if (!it.hasNext()) {
            return new YangInstanceIdentifierWriter(writer, 0);
        }
        int endNodes = 0;
        DataNodeContainer parent = root;
        boolean reuse = false;
        boolean terminal = false;
        block19: do {
            YangInstanceIdentifier.PathArgument pathArgument;
            if (terminal) {
                throw new IOException(String.valueOf(parent) + " is a terminal node, cannot resolve " + String.valueOf(ImmutableList.copyOf(it)));
            }
            YangInstanceIdentifier.PathArgument arg = it.next();
            Objects.requireNonNull(arg);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{YangInstanceIdentifier.NodeWithValue.class, YangInstanceIdentifier.NodeIdentifierWithPredicates.class, YangInstanceIdentifier.NodeIdentifier.class}, (Object)pathArgument, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    YangInstanceIdentifier.NodeWithValue nodeId = (YangInstanceIdentifier.NodeWithValue)pathArgument;
                    if (!(parent instanceof LeafListSchemaNode)) {
                        throw new IOException(String.valueOf(parent) + " does not support leaf-list entry " + String.valueOf(arg));
                    }
                    if (!reuse) {
                        throw new IOException(String.valueOf(parent) + " is already at its entry, cannot enter " + String.valueOf(arg));
                    }
                    reuse = false;
                    terminal = true;
                    writer.startLeafSetEntryNode(nodeId);
                    break;
                }
                case 1: {
                    YangInstanceIdentifier.NodeIdentifierWithPredicates nodeId = (YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArgument;
                    if (!(parent instanceof ListSchemaNode)) {
                        throw new IOException(String.valueOf(parent) + " does not support map entry " + String.valueOf(arg));
                    }
                    ListSchemaNode list = (ListSchemaNode)parent;
                    if (!reuse) {
                        throw new IOException(String.valueOf(parent) + " is already at its entry, cannot enter " + String.valueOf(arg));
                    }
                    if (!list.getQName().equals((Object)nodeId.getNodeType())) {
                        throw new IOException(String.valueOf(parent) + " expects a matching map entry, cannot enter " + String.valueOf(arg));
                    }
                    List key = list.getKeyDefinition();
                    if (key.isEmpty()) {
                        throw new IOException(String.valueOf(parent) + " does not expect map entry " + String.valueOf(arg));
                    }
                    if (key.size() != nodeId.size()) {
                        throw new IOException(String.valueOf(parent) + " expects " + key.size() + " predicates, cannot use " + String.valueOf(arg));
                    }
                    reuse = false;
                    writer.startMapEntryNode(YangInstanceIdentifierWriter.normalizePredicates(nodeId, key), 1);
                    break;
                }
                case 2: {
                    YangInstanceIdentifier.NodeIdentifier nodeId = (YangInstanceIdentifier.NodeIdentifier)pathArgument;
                    if (reuse) {
                        if (!(parent instanceof ListSchemaNode)) {
                            throw new IOException(String.valueOf(parent) + " expects an identifiable entry, cannot enter " + String.valueOf(arg));
                        }
                        ListSchemaNode list = (ListSchemaNode)parent;
                        if (!list.getKeyDefinition().isEmpty()) {
                            throw new IOException(String.valueOf(parent) + " expects a map entry, cannot enter " + String.valueOf(arg));
                        }
                        if (!list.getQName().equals((Object)nodeId.getNodeType())) {
                            throw new IOException(String.valueOf(parent) + " expects a matching entry, cannot enter " + String.valueOf(arg));
                        }
                        reuse = false;
                        writer.startUnkeyedListItem(nodeId, 1);
                        ++endNodes;
                        continue block19;
                    }
                    DataNodeContainer dataNodeContainer = parent;
                    Objects.requireNonNull(dataNodeContainer);
                    DataNodeContainer dataNodeContainer2 = dataNodeContainer;
                    int n2 = 0;
                    DataSchemaNode child = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataNodeContainer.class, ChoiceSchemaNode.class}, (Object)dataNodeContainer2, n2)) {
                        case 0 -> {
                            DataNodeContainer container = dataNodeContainer2;
                            yield container.dataChildByName(nodeId.getNodeType());
                        }
                        case 1 -> {
                            ChoiceSchemaNode choice = (ChoiceSchemaNode)dataNodeContainer2;
                            yield choice.findDataSchemaChild(nodeId.getNodeType()).orElse(null);
                        }
                        default -> throw new IOException("Unhandled parent " + String.valueOf(parent) + " when looking up " + String.valueOf(arg));
                    };
                    dataNodeContainer2 = child;
                    n2 = 0;
                    parent = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnydataSchemaNode.class, AnyxmlSchemaNode.class, ChoiceSchemaNode.class, ContainerLike.class, LeafSchemaNode.class, LeafListSchemaNode.class, ListSchemaNode.class}, (Object)dataNodeContainer2, n2)) {
                        case -1 -> throw new IOException("Failed to find child " + String.valueOf(arg) + " in parent " + String.valueOf(parent));
                        case 0 -> {
                            AnydataSchemaNode anydata = (AnydataSchemaNode)dataNodeContainer2;
                            writer.startAnydataNode(nodeId, NormalizedAnydata.class);
                            terminal = true;
                            yield anydata;
                        }
                        case 1 -> {
                            AnyxmlSchemaNode anyxml = (AnyxmlSchemaNode)dataNodeContainer2;
                            writer.startAnyxmlNode(nodeId, DOMSource.class);
                            terminal = true;
                            yield anyxml;
                        }
                        case 2 -> {
                            ChoiceSchemaNode choice = (ChoiceSchemaNode)dataNodeContainer2;
                            writer.startChoiceNode(nodeId, 1);
                            yield choice;
                        }
                        case 3 -> {
                            ContainerLike containerLike = (ContainerLike)dataNodeContainer2;
                            writer.startContainerNode(nodeId, 1);
                            yield containerLike;
                        }
                        case 4 -> {
                            LeafSchemaNode leaf = (LeafSchemaNode)dataNodeContainer2;
                            writer.startLeafNode(nodeId);
                            terminal = true;
                            yield leaf;
                        }
                        case 5 -> {
                            LeafListSchemaNode leafList = (LeafListSchemaNode)dataNodeContainer2;
                            if (leafList.isUserOrdered()) {
                                writer.startOrderedLeafSet(nodeId, 1);
                            } else {
                                writer.startLeafSet(nodeId, 1);
                            }
                            reuse = true;
                            yield leafList;
                        }
                        case 6 -> {
                            ListSchemaNode list = (ListSchemaNode)dataNodeContainer2;
                            if (list.getKeyDefinition().isEmpty()) {
                                writer.startUnkeyedList(nodeId, 1);
                            } else if (list.isUserOrdered()) {
                                writer.startOrderedMapNode(nodeId, 1);
                            } else {
                                writer.startMapNode(nodeId, 1);
                            }
                            reuse = true;
                            yield list;
                        }
                        default -> throw new IOException("Unhandled child " + String.valueOf(child));
                    };
                }
            }
            ++endNodes;
        } while (it.hasNext());
        return new YangInstanceIdentifierWriter(writer, endNodes);
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            for (int i = 0; i < this.endNodeCount; ++i) {
                this.writer.endNode();
            }
            this.writer = null;
        }
    }

    private static YangInstanceIdentifier.NodeIdentifierWithPredicates normalizePredicates(YangInstanceIdentifier.NodeIdentifierWithPredicates input, List<QName> key) throws IOException {
        if (Iterables.elementsEqual(input.keySet(), key)) {
            return input;
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)key.size());
        for (QName qname : key) {
            Object value = input.getValue(qname);
            if (value == null) {
                throw new IOException("Cannot normalize " + String.valueOf(input) + " to " + String.valueOf(key) + ", missing value for " + String.valueOf(qname));
            }
            builder.put((Object)qname, value);
        }
        return YangInstanceIdentifier.NodeIdentifierWithPredicates.of(input.getNodeType(), ImmutableOffsetMap.orderedCopyOf((Map)builder.build()));
    }
}

