/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema;

import com.google.common.annotations.Beta;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointChild;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointContext;
import org.opendaylight.yangtools.yang.data.api.schema.MountPointException;

@Beta
@NonNullByDefault
public interface MountPointContextFactory {
    public MountPointContext createContext(Map<ContainerName, MountPointChild> var1, @Nullable MountPointChild var2) throws MountPointException;

    public static enum ContainerName {
        RFC8525("yang-library"),
        RFC7895("modules-state");

        private final String localName;

        private ContainerName(String localName) {
            this.localName = Objects.requireNonNull(localName);
        }

        public String getLocalName() {
            return this.localName;
        }

        public static ContainerName ofLocalName(String localName) {
            ContainerName ret = ContainerName.forLocalName(localName);
            if (ret == null) {
                throw new IllegalArgumentException("Unrecognized container name '" + localName + "'");
            }
            return ret;
        }

        public static @Nullable ContainerName forLocalName(String localName) {
            return switch (localName) {
                case "yang-library" -> RFC8525;
                case "modules-state" -> RFC7895;
                default -> null;
            };
        }
    }
}

