/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.primitives.UnsignedLong;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Variant;
import org.opendaylight.yangtools.yang.common.AbstractCanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValue;
import org.opendaylight.yangtools.yang.common.CanonicalValueSupport;
import org.opendaylight.yangtools.yang.common.CanonicalValueViolation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;

@Beta
@NonNullByDefault
public class Uint64
extends Number
implements CanonicalValue<Uint64> {
    private static final CanonicalValueSupport<Uint64> SUPPORT = new Support();
    private static final long serialVersionUID = 1L;
    private static final long MIN_VALUE = 0L;
    private static final Uint64[] CACHE = new Uint64[255];
    private static final Uint64[] COMMON = new Uint64[]{new Uint64(32768L), new Uint64(32768L), new Uint64(65535L), new Uint64(65536L), new Uint64(Integer.MAX_VALUE), new Uint64(0x80000000L), new Uint64(Long.MAX_VALUE)};
    private static final int DEFAULT_LRU_SIZE = 1024;
    private static final String LRU_SIZE_PROPERTY = "org.opendaylight.yangtools.yang.common.Uint64.LRU.size";
    private static final int MAX_LRU_SIZE = 0xFFFFFF;
    private static final int LRU_SIZE;
    private static final LoadingCache<Long, Uint64> LRU;
    private final long value;

    Uint64(long value) {
        this.value = value;
    }

    protected Uint64(Uint64 other) {
        this.value = other.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Uint64 instanceFor(long value) {
        int slot = (int)value;
        if (slot < 0 || slot >= CACHE.length) {
            for (Uint64 c : COMMON) {
                if (c.value != value) continue;
                return c;
            }
            return (Uint64)LRU.getUnchecked((Object)value);
        }
        Uint64 ret = CACHE[slot];
        if (ret != null) return ret;
        Uint64[] uint64Array = CACHE;
        synchronized (CACHE) {
            ret = CACHE[slot];
            if (ret != null) return ret;
            Uint64.CACHE[slot] = ret = new Uint64(value);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return ret;
        }
    }

    public static Uint64 fromLongBits(long bits) {
        return Uint64.instanceFor(bits);
    }

    public static Uint64 fromUnsignedLong(UnsignedLong ulong) {
        return Uint64.instanceFor(ulong.longValue());
    }

    public static Uint64 valueOf(byte byteVal) {
        Preconditions.checkArgument(((long)byteVal >= 0L ? 1 : 0) != 0, (Object)"Negative values are not allowed");
        return Uint64.instanceFor(byteVal);
    }

    public static Uint64 valueOf(short shortVal) {
        Preconditions.checkArgument(((long)shortVal >= 0L ? 1 : 0) != 0, (Object)"Negative values are not allowed");
        return Uint64.instanceFor(shortVal);
    }

    public static Uint64 valueOf(int intVal) {
        Preconditions.checkArgument(((long)intVal >= 0L ? 1 : 0) != 0, (String)"Value %s is outside of allowed range", (int)intVal);
        return Uint64.instanceFor(intVal);
    }

    public static Uint64 valueOf(long longVal) {
        Preconditions.checkArgument((longVal >= 0L ? 1 : 0) != 0, (String)"Value %s is outside of allowed range", (long)longVal);
        return Uint64.instanceFor(longVal);
    }

    public static Uint64 valueOf(Uint8 uint) {
        return Uint64.instanceFor(uint.shortValue());
    }

    public static Uint64 valueOf(Uint16 uint) {
        return Uint64.instanceFor(uint.intValue());
    }

    public static Uint64 valueOf(Uint32 uint) {
        return Uint64.instanceFor(uint.longValue());
    }

    public static Uint64 valueOf(String string) {
        return Uint64.valueOf(string, 10);
    }

    public static Uint64 valueOf(String string, int radix) {
        return Uint64.instanceFor(Long.parseUnsignedLong(string, radix));
    }

    public static Uint64 valueOf(BigInteger bigInt) {
        Preconditions.checkArgument((bigInt.signum() >= 0 ? 1 : 0) != 0, (Object)"Negative values not allowed");
        Preconditions.checkArgument((bigInt.bitLength() <= 64 ? 1 : 0) != 0, (String)"Value %s is outside of allowed range", (Object)bigInt);
        return Uint64.instanceFor(bigInt.longValue());
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return UnsignedLong.fromLongBits((long)this.value).floatValue();
    }

    @Override
    public final double doubleValue() {
        return UnsignedLong.fromLongBits((long)this.value).doubleValue();
    }

    public final UnsignedLong toUnsignedLong() {
        return UnsignedLong.fromLongBits((long)this.value);
    }

    @Override
    public final int compareTo(Uint64 o) {
        return Long.compareUnsigned(this.value, o.value);
    }

    @Override
    public final String toCanonicalString() {
        return Long.toUnsignedString(this.value);
    }

    @Override
    public final CanonicalValueSupport<Uint64> support() {
        return SUPPORT;
    }

    public final int hashCode() {
        return Long.hashCode(this.value);
    }

    public final boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof Uint64 && this.value == ((Uint64)obj).value;
    }

    public final String toString() {
        return this.toCanonicalString();
    }

    private Object readResolve() {
        return Uint64.instanceFor(this.value);
    }

    static {
        int p = Integer.getInteger(LRU_SIZE_PROPERTY, 1024);
        LRU_SIZE = p >= 0 ? Math.min(p, 0xFFFFFF) : 1024;
        LRU = CacheBuilder.newBuilder().weakValues().maximumSize((long)LRU_SIZE).build((CacheLoader)new CacheLoader<Long, Uint64>(){

            public Uint64 load(Long key) {
                return new Uint64(key);
            }
        });
    }

    public static final class Support
    extends AbstractCanonicalValueSupport<Uint64> {
        public Support() {
            super(Uint64.class);
        }

        @Override
        public Variant<Uint64, CanonicalValueViolation> fromString(String str) {
            try {
                return Variant.ofFirst((Object)Uint64.valueOf(str));
            }
            catch (IllegalArgumentException e) {
                return CanonicalValueViolation.variantOf(e);
            }
        }
    }
}

