/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.ErrorSeverity;
import org.opendaylight.yangtools.yang.common.ErrorTag;
import org.opendaylight.yangtools.yang.common.ErrorType;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.RpcResult;

public final class RpcResultBuilder<T>
implements Mutable {
    private ImmutableList.Builder<RpcError> errors;
    private T result;
    private final boolean successful;

    private RpcResultBuilder(boolean successful, T result) {
        this.successful = successful;
        this.result = result;
    }

    public static <T> @NonNull RpcResultBuilder<T> success() {
        return new RpcResultBuilder<Object>(true, null);
    }

    public static <T> @NonNull RpcResultBuilder<T> success(T result) {
        return new RpcResultBuilder<T>(true, result);
    }

    public static <T> @NonNull RpcResultBuilder<T> failed() {
        return new RpcResultBuilder<Object>(false, null);
    }

    public static <T> @NonNull RpcResultBuilder<T> status(boolean success) {
        return new RpcResultBuilder<Object>(success, null);
    }

    public static <T> @NonNull RpcResultBuilder<T> from(RpcResult<T> other) {
        return new RpcResultBuilder<T>(other.isSuccessful(), other.getResult()).withRpcErrors(other.getErrors());
    }

    public static @NonNull RpcError newError(ErrorType errorType, ErrorTag tag, String message) {
        return new RpcErrorImpl(ErrorSeverity.ERROR, errorType, tag != null ? tag : ErrorTag.OPERATION_FAILED, message, null, null, null);
    }

    public static @NonNull RpcError newError(ErrorType errorType, ErrorTag tag, String message, String applicationTag, String info, Throwable cause) {
        return new RpcErrorImpl(ErrorSeverity.ERROR, errorType, tag != null ? tag : ErrorTag.OPERATION_FAILED, message, applicationTag, info, cause);
    }

    public static @NonNull RpcError newWarning(ErrorType errorType, ErrorTag tag, String message) {
        return new RpcErrorImpl(ErrorSeverity.WARNING, errorType, tag, message, null, null, null);
    }

    public static @NonNull RpcError newWarning(ErrorType errorType, ErrorTag tag, String message, String applicationTag, String info, Throwable cause) {
        return new RpcErrorImpl(ErrorSeverity.WARNING, errorType, tag, message, applicationTag, info, cause);
    }

    public @NonNull RpcResultBuilder<T> withResult(T result) {
        this.result = result;
        return this;
    }

    private void addError(ErrorSeverity severity, ErrorType errorType, ErrorTag tag, String message, String applicationTag, String info, Throwable cause) {
        this.addError(new RpcErrorImpl(severity, errorType, tag != null ? tag : ErrorTag.OPERATION_FAILED, message, applicationTag, info, cause));
    }

    private void addError(RpcError error) {
        if (this.errors == null) {
            this.errors = new ImmutableList.Builder();
        }
        this.errors.add((Object)error);
    }

    public @NonNull RpcResultBuilder<T> withWarning(ErrorType errorType, ErrorTag tag, String message) {
        this.addError(ErrorSeverity.WARNING, errorType, tag, message, null, null, null);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withWarning(ErrorType errorType, ErrorTag tag, String message, String applicationTag, String info, Throwable cause) {
        this.addError(ErrorSeverity.WARNING, errorType, tag, message, applicationTag, info, cause);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(ErrorType errorType, String message) {
        this.addError(ErrorSeverity.ERROR, errorType, null, message, null, null, null);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(ErrorType errorType, ErrorTag tag, String message) {
        this.addError(ErrorSeverity.ERROR, errorType, tag, message, null, null, null);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(ErrorType errorType, String message, Throwable cause) {
        this.addError(ErrorSeverity.ERROR, errorType, null, message, null, null, cause);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withError(ErrorType errorType, ErrorTag tag, String message, String applicationTag, String info, Throwable cause) {
        this.addError(ErrorSeverity.ERROR, errorType, tag, message, applicationTag, info, cause);
        return this;
    }

    public @NonNull RpcResultBuilder<T> withRpcError(RpcError error) {
        this.addError(error);
        return this;
    }

    public RpcResultBuilder<T> withRpcErrors(Collection<? extends RpcError> rpcErrors) {
        if (rpcErrors != null) {
            for (RpcError rpcError : rpcErrors) {
                this.addError(rpcError);
            }
        }
        return this;
    }

    public @NonNull RpcResult<T> build() {
        return new RpcResultImpl<T>(this.successful, this.result, (ImmutableList<RpcError>)(this.errors != null ? this.errors.build() : ImmutableList.of()));
    }

    public @NonNull FluentFuture<RpcResult<T>> buildFuture() {
        return FluentFuture.from((ListenableFuture)Futures.immediateFuture(this.build()));
    }

    private static class RpcErrorImpl
    implements RpcError,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String applicationTag;
        private final ErrorTag tag;
        private final String info;
        private final ErrorSeverity severity;
        private final String message;
        private final ErrorType errorType;
        private final Throwable cause;

        RpcErrorImpl(ErrorSeverity severity, ErrorType errorType, ErrorTag tag, String message, String applicationTag, String info, Throwable cause) {
            this.severity = severity;
            this.errorType = errorType;
            this.tag = tag;
            this.message = message;
            this.applicationTag = applicationTag;
            this.info = info;
            this.cause = cause;
        }

        @Override
        public String getApplicationTag() {
            return this.applicationTag;
        }

        @Override
        public ErrorTag getTag() {
            return this.tag;
        }

        @Override
        public String getInfo() {
            return this.info;
        }

        @Override
        public ErrorSeverity getSeverity() {
            return this.severity;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public ErrorType getErrorType() {
            return this.errorType;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }

        public String toString() {
            return "RpcError [message=" + this.message + ", severity=" + String.valueOf((Object)this.severity) + ", errorType=" + String.valueOf((Object)this.errorType) + ", tag=" + String.valueOf(this.tag) + ", applicationTag=" + this.applicationTag + ", info=" + this.info + ", cause=" + String.valueOf(this.cause) + "]";
        }
    }

    private static class RpcResultImpl<T>
    implements RpcResult<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ImmutableList<RpcError> errors;
        private final T result;
        private final boolean successful;

        RpcResultImpl(boolean successful, T result, ImmutableList<RpcError> errors) {
            this.successful = successful;
            this.result = result;
            this.errors = Objects.requireNonNull(errors);
        }

        public ImmutableList<RpcError> getErrors() {
            return this.errors;
        }

        @Override
        public T getResult() {
            return this.result;
        }

        @Override
        public boolean isSuccessful() {
            return this.successful;
        }

        public String toString() {
            return "RpcResult [successful=" + this.successful + ", result=" + String.valueOf(this.result) + ", errors=" + String.valueOf(this.errors) + "]";
        }
    }
}

