/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.NSv1;
import org.opendaylight.yangtools.yang.common.NotRevision;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.RevisionUnion;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

public final class QNameModule
implements Comparable<QNameModule>,
Immutable,
Serializable,
Identifier,
WritableObject {
    private static final Interner<QNameModule> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 3L;
    private final @NonNull XMLNamespace namespace;
    private final @NonNull RevisionUnion revUnion;
    private transient int hash = 0;

    private QNameModule(XMLNamespace namespace, RevisionUnion revUnion) {
        this.namespace = Objects.requireNonNull(namespace);
        this.revUnion = Objects.requireNonNull(revUnion);
    }

    public static @NonNull QNameModule of(XMLNamespace namespace) {
        return QNameModule.of(namespace, RevisionUnion.none());
    }

    public static @NonNull QNameModule of(XMLNamespace namespace, RevisionUnion revUnion) {
        return new QNameModule(namespace, revUnion);
    }

    public static @NonNull QNameModule of(XMLNamespace namespace, Revision revision) {
        return new QNameModule(namespace, revision);
    }

    public static @NonNull QNameModule of(String namespace) {
        return QNameModule.of(XMLNamespace.of(namespace));
    }

    public static @NonNull QNameModule of(String namespace, String unionString) {
        return QNameModule.of(XMLNamespace.of(namespace), RevisionUnion.of(unionString));
    }

    public static @NonNull QNameModule ofRevision(XMLNamespace namespace, @Nullable Revision revision) {
        return QNameModule.of(namespace, revision != null ? revision : RevisionUnion.none());
    }

    public static @NonNull QNameModule ofRevision(String namespace, @Nullable String revision) {
        return QNameModule.of(XMLNamespace.of(namespace), revision != null ? Revision.of(revision) : RevisionUnion.none());
    }

    public static @NonNull QNameModule readFrom(DataInput in) throws IOException {
        return new QNameModule(XMLNamespace.readFrom(in), RevisionUnion.readFrom(in));
    }

    public @NonNull XMLNamespace namespace() {
        return this.namespace;
    }

    public @NonNull RevisionUnion revisionUnion() {
        return this.revUnion;
    }

    public @Nullable Revision revision() {
        return this.revUnion.revision();
    }

    public @NonNull Optional<Revision> findRevision() {
        return this.revUnion.findRevision();
    }

    public @NonNull QNameModule intern() {
        return (QNameModule)INTERNER.intern((Object)this);
    }

    @Override
    public int compareTo(QNameModule o) {
        int cmp = this.namespace.compareTo(o.namespace);
        return cmp != 0 ? cmp : this.revUnion.compareTo(o.revUnion);
    }

    public @NonNull QNameModule withoutRevision() {
        return this.revUnion instanceof NotRevision ? this : QNameModule.of(this.namespace);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.namespace.toString());
        out.writeUTF(this.revUnion.unionString());
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.namespace, this.revUnion);
        }
        return this.hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof QNameModule)) return false;
        QNameModule other = (QNameModule)obj;
        if (!this.revUnion.equals(other.revUnion)) return false;
        if (!this.namespace.equals(other.namespace)) return false;
        return true;
    }

    public @NonNull String toString() {
        return MoreObjects.toStringHelper(QNameModule.class).omitNullValues().add("ns", (Object)this.namespace).add("rev", (Object)this.revUnion.revision()).toString();
    }

    Object writeReplace() {
        return new NSv1(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Revision.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        Revision.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        Revision.throwNSE();
    }
}

