/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.NotRevision;
import org.opendaylight.yangtools.yang.common.Revision;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
public interface RevisionUnion
extends Comparable<RevisionUnion>,
Immutable,
Serializable,
WritableObject {
    public static NotRevision none() {
        return NotRevision.of();
    }

    public static RevisionUnion of(String unionString) {
        return unionString.isEmpty() ? RevisionUnion.none() : Revision.of(unionString);
    }

    public static RevisionUnion of(@Nullable Revision revision) {
        return revision != null ? revision : RevisionUnion.none();
    }

    public String unionString();

    public @Nullable Revision revision();

    default public Optional<Revision> findRevision() {
        return Optional.ofNullable(this.revision());
    }

    default public Revision getRevision() {
        Revision revision = this.revision();
        if (revision == null) {
            throw new NoSuchElementException();
        }
        return revision;
    }

    @Override
    default public int compareTo(RevisionUnion o) {
        return this.unionString().compareTo(o.unionString());
    }

    default public void writeTo(DataOutput out) throws IOException {
        out.writeUTF(this.unionString());
    }

    public static RevisionUnion readFrom(DataInput in) throws IOException {
        String unionString = in.readUTF();
        return unionString.isEmpty() ? RevisionUnion.none() : Revision.ofRead(unionString);
    }

    public int hashCode();

    public boolean equals(@Nullable Object var1);

    public String toString();
}

