/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.charset.StandardCharsets;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.RevisionUnion;

final class RUv1
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final int LENGTH = Revision.MAX_VALUE.unionString().length();
    private String dateString;

    public RUv1() {
    }

    RUv1(String dateString) {
        int length = dateString.length();
        if (length != 0 && length != LENGTH) {
            throw new IllegalArgumentException("Unexpected string length " + length);
        }
        this.dateString = dateString;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int length = this.dateString.length();
        out.writeByte(length);
        if (length != 0) {
            out.write(this.dateString.getBytes(StandardCharsets.US_ASCII));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        byte length = in.readByte();
        if (length == LENGTH) {
            byte[] bytes = new byte[length];
            in.readFully(bytes);
            this.dateString = new String(bytes, StandardCharsets.US_ASCII);
        } else if (length == 0) {
            this.dateString = "";
        } else {
            throw new IOException("Unexpected byte length " + length);
        }
    }

    private Object readResolve() {
        return RevisionUnion.of(this.dateString);
    }
}

