/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.annotations.Beta;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.regex.qual.Regex;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.AbstractQName;
import org.opendaylight.yangtools.yang.common.QNameAwareDataInput;
import org.opendaylight.yangtools.yang.common.QNameAwareDataOutput;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.QNv1;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.XMLNamespace;

public final class QName
extends AbstractQName
implements Comparable<QName> {
    private static final Interner<QName> INTERNER = Interners.newWeakInterner();
    private static final long serialVersionUID = 1L;
    private static final @Regex String QNAME_STRING_FULL = "^\\((.+)\\?revision=(.+)\\)(.+)$";
    private static final Pattern QNAME_PATTERN_FULL = Pattern.compile("^\\((.+)\\?revision=(.+)\\)(.+)$");
    private static final @Regex String QNAME_STRING_NO_REVISION = "^\\((.+)\\)(.+)$";
    private static final Pattern QNAME_PATTERN_NO_REVISION = Pattern.compile("^\\((.+)\\)(.+)$");
    private final @NonNull QNameModule module;
    private transient int hash = 0;

    QName(QNameModule module, @NonNull String localName) {
        super(localName);
        this.module = Objects.requireNonNull(module);
    }

    private QName(XMLNamespace namespace, String localName) {
        this(QNameModule.of(namespace), QName.checkLocalName(localName));
    }

    public static @NonNull QName create(String input) {
        Matcher matcher = QNAME_PATTERN_FULL.matcher(input);
        if (matcher.matches()) {
            String namespace = matcher.group(1);
            String revision = matcher.group(2);
            String localName = matcher.group(3);
            return QName.create(namespace, revision, localName);
        }
        matcher = QNAME_PATTERN_NO_REVISION.matcher(input);
        if (matcher.matches()) {
            XMLNamespace namespace = XMLNamespace.of(matcher.group(1));
            String localName = matcher.group(2);
            return new QName(namespace, localName);
        }
        throw new IllegalArgumentException("Invalid input: " + input);
    }

    public static @NonNull QName create(QName base, String localName) {
        return QName.create(base.getModule(), localName);
    }

    public static @NonNull QName create(QNameModule qnameModule, String localName) {
        return new QName(Objects.requireNonNull(qnameModule, "module may not be null"), QName.checkLocalName(localName));
    }

    public static @NonNull QName create(XMLNamespace namespace, @Nullable Revision revision, String localName) {
        return QName.create(QNameModule.ofRevision(namespace, revision), localName);
    }

    public static @NonNull QName create(XMLNamespace namespace, Optional<Revision> revision, String localName) {
        return QName.create(QNameModule.ofRevision(namespace, revision.orElse(null)), localName);
    }

    public static @NonNull QName create(String namespace, String localName, Revision revision) {
        return QName.create(QNameModule.of(XMLNamespace.of(namespace), revision), localName);
    }

    public static @NonNull QName create(String namespace, String revision, String localName) {
        return QName.create(QNameModule.ofRevision(namespace, revision), localName);
    }

    public static @NonNull QName create(String namespace, String localName) {
        return QName.create(XMLNamespace.of(namespace), localName);
    }

    public static @NonNull QName create(XMLNamespace namespace, String localName) {
        return new QName(namespace, localName);
    }

    public static @NonNull QName readFrom(DataInput in) throws IOException {
        if (in instanceof QNameAwareDataInput) {
            QNameAwareDataInput aware = (QNameAwareDataInput)in;
            return aware.readQName();
        }
        QNameModule module = QNameModule.readFrom(in);
        return new QName(module, QName.checkLocalName(in.readUTF()));
    }

    @Beta
    public static @NonNull QName unsafeOf(@NonNull QNameModule qnameModule, @NonNull String localName) {
        return new QName(qnameModule, localName);
    }

    public @NonNull QNameModule getModule() {
        return this.module;
    }

    public @NonNull XMLNamespace getNamespace() {
        return this.module.namespace();
    }

    public @NonNull Optional<Revision> getRevision() {
        return this.module.findRevision();
    }

    @Override
    public @NonNull QName intern() {
        QNameModule cacheMod = this.module.intern();
        QName template = cacheMod == this.module ? this : new QName(cacheMod, this.getLocalName().intern());
        return (QName)INTERNER.intern((Object)template);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Objects.hash(this.module, this.getLocalName());
        }
        return this.hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof QName)) return false;
        QName other = (QName)obj;
        if (!this.getLocalName().equals(other.getLocalName())) return false;
        if (!this.module.equals(other.module)) return false;
        return true;
    }

    @Override
    public @NonNull String toString() {
        StringBuilder sb = new StringBuilder().append('(').append(this.getNamespace());
        Optional<Revision> rev = this.getRevision();
        if (rev.isPresent()) {
            sb.append("?revision=").append(rev.orElseThrow());
        }
        return sb.append(')').append(this.getLocalName()).toString();
    }

    @Override
    public @NonNull QName bindTo(QNameModule namespace) {
        return this.module.equals(namespace) ? this : super.bindTo(namespace);
    }

    public @NonNull QName withoutRevision() {
        QNameModule newModule = this.module.withoutRevision();
        return newModule == this.module ? this : new QName(newModule, this.getLocalName());
    }

    public static @Nullable String formattedRevision(Optional<Revision> revision) {
        return revision.map(Revision::toString).orElse(null);
    }

    public boolean isEqualWithoutRevision(QName other) {
        return this.getLocalName().equals(other.getLocalName()) && Objects.equals(this.getNamespace(), other.getNamespace());
    }

    @Override
    public int compareTo(QName o) {
        int result = this.module.compareTo(o.module);
        return result != 0 ? result : this.getLocalName().compareTo(o.getLocalName());
    }

    public void writeTo(DataOutput out) throws IOException {
        if (out instanceof QNameAwareDataOutput) {
            QNameAwareDataOutput aware = (QNameAwareDataOutput)out;
            aware.writeQName(this);
        } else {
            this.module.writeTo(out);
            out.writeUTF(this.getLocalName());
        }
    }

    @Override
    Object writeReplace() {
        return new QNv1(this);
    }
}

