/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.common;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.YangNames;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NonNullByDefault
public abstract class AbstractQName
implements Identifier,
WritableObject {
    private static final long serialVersionUID = 1L;
    private final String localName;

    AbstractQName(String localName) {
        this.localName = Objects.requireNonNull(localName);
    }

    public final String getLocalName() {
        return this.localName;
    }

    public abstract AbstractQName intern();

    public abstract int hashCode();

    public abstract boolean equals(@Nullable Object var1);

    public abstract String toString();

    public QName bindTo(QNameModule namespace) {
        return new QName(namespace, this.getLocalName());
    }

    static final boolean isValidLocalName(@Nullable String str) {
        return str != null && !str.isEmpty() && AbstractQName.checkContent(str);
    }

    abstract Object writeReplace();

    static final String checkLocalName(@Nullable String localName) {
        Preconditions.checkArgument((!localName.isEmpty() ? 1 : 0) != 0, (Object)"Parameter 'localName' must be a non-empty string.");
        Preconditions.checkArgument((boolean)AbstractQName.checkContent(localName), (String)"String '%s' is not a valid identifier", (Object)localName);
        return localName;
    }

    private static boolean checkContent(String localName) {
        return YangNames.IDENTIFIER_START.matches(localName.charAt(0)) && YangNames.NOT_IDENTIFIER_PART.indexIn((CharSequence)localName, 1) == -1;
    }
}

