/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8819.parser;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.rfc8819.model.api.ModuleTagEffectiveStatement;
import org.opendaylight.yangtools.rfc8819.model.api.ModuleTagStatement;
import org.opendaylight.yangtools.rfc8819.model.api.ModuleTagStatements;
import org.opendaylight.yangtools.rfc8819.model.api.Tag;
import org.opendaylight.yangtools.rfc8819.parser.ModuleTagEffectiveStatementImpl;
import org.opendaylight.yangtools.rfc8819.parser.ModuleTagStatementImpl;
import org.opendaylight.yangtools.rfc8819.parser.RefModuleTagStatement;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclarationReference;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.api.YangParserConfiguration;
import org.opendaylight.yangtools.yang.parser.spi.meta.AbstractStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.BoundStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.EffectiveStmtCtx;
import org.opendaylight.yangtools.yang.parser.spi.meta.StatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;

@Beta
public final class ModuleTagStatementSupport
extends AbstractStatementSupport<Tag, ModuleTagStatement, ModuleTagEffectiveStatement> {
    private static final SubstatementValidator VALIDATOR = SubstatementValidator.builder((StatementDefinition)ModuleTagStatements.MODULE_TAG).build();

    public ModuleTagStatementSupport(YangParserConfiguration config) {
        super((StatementDefinition)ModuleTagStatements.MODULE_TAG, StatementSupport.StatementPolicy.reject(), config, VALIDATOR);
    }

    public String internArgument(String rawArgument) {
        return rawArgument != null ? rawArgument.intern() : null;
    }

    public Tag parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        try {
            return new Tag(value).intern();
        }
        catch (IllegalArgumentException e) {
            throw new SourceException(ctx, (Throwable)e, "Invalid tag value '%s'", new Object[]{value});
        }
    }

    public void onStatementAdded(StmtContext.Mutable<Tag, ModuleTagStatement, ModuleTagEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().publicDefinition();
        SourceException.throwIf((YangStmtMapping.MODULE != parentDef && YangStmtMapping.SUBMODULE != parentDef ? 1 : 0) != 0, stmt, (String)"Tags may only be defined at root of either a module or a submodule", (Object[])new Object[0]);
    }

    protected ModuleTagStatement createDeclared(BoundStmtCtx<Tag> ctx, ImmutableList<DeclaredStatement<?>> substatements) {
        return new ModuleTagStatementImpl((Tag)ctx.getArgument(), substatements);
    }

    protected ModuleTagStatement attachDeclarationReference(ModuleTagStatement stmt, DeclarationReference reference) {
        return new RefModuleTagStatement(stmt, reference);
    }

    protected ModuleTagEffectiveStatement createEffective(EffectiveStmtCtx.Current<Tag, ModuleTagStatement> stmt, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new ModuleTagEffectiveStatementImpl((ModuleTagStatement)stmt.declared(), substatements);
    }
}

