/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8819.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8819.model.api.Prefix;

@Beta
public record Tag(@NonNull String value) {
    private static final Interner<@NonNull Tag> INTERNER = Interners.newWeakInterner();
    private static final Pattern TAG_VALUE_PATTERN = Pattern.compile("^[\\x20-\\uDFFF\\uE000-\\uFDCF\\uFDF0-\\uFFFD\\x{10000}-\\x{1FFFD}\\x{20000}-\\x{2FFFD}\\x{30000}-\\x{3FFFD}\\x{40000}-\\x{4FFFD}\\x{50000}-\\x{5FFFD}\\x{60000}-\\x{6FFFD}\\x{70000}-\\x{7FFFD}\\x{80000}-\\x{8FFFD}\\x{90000}-\\x{9FFFD}\\x{A0000}-\\x{AFFFD}\\x{B0000}-\\x{BFFFD}\\x{C0000}-\\x{CFFFD}\\x{D0000}-\\x{DFFFD}\\x{E0000}-\\x{EFFFD}\\x{F0000}-\\x{FFFFD}\\x{100000}-\\x{10FFFD}]+$");

    public Tag(@NonNull String value) {
        Objects.requireNonNull(value);
        Preconditions.checkArgument((boolean)Tag.isValidValue(value), (String)"Invalid tag value '%s'.", (Object)value);
    }

    public boolean hasPrefix(Prefix prefix) {
        return this.value.startsWith(prefix.value());
    }

    public @NonNull Tag intern() {
        return (Tag)INTERNER.intern((Object)this);
    }

    static boolean isValidValue(String str) {
        return TAG_VALUE_PATTERN.matcher(str).matches();
    }
}

