/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.model.api;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointEffectiveStatement;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointStatement;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountConstants;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.meta.ArgumentDefinition;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

@NonNullByDefault
public enum SchemaMountStatements implements StatementDefinition
{
    MOUNT_POINT(QName.create((QNameModule)SchemaMountConstants.RFC8528_MODULE, (String)"mount-point"), "label", MountPointStatement.class, MountPointEffectiveStatement.class);

    private final Class<? extends EffectiveStatement<?, ?>> effectiveRepresentation;
    private final Class<? extends DeclaredStatement<?>> declaredRepresentation;
    private final QName statementName;
    private final ArgumentDefinition argumentDef;

    private SchemaMountStatements(QName statementName, String argumentName, Class<? extends DeclaredStatement<?>> declaredRepresentation, Class<? extends EffectiveStatement<?, ?>> effectiveRepresentation) {
        this.statementName = statementName.intern();
        this.argumentDef = ArgumentDefinition.of((QName)QName.create((QName)statementName, (String)argumentName), (boolean)false);
        this.declaredRepresentation = Objects.requireNonNull(declaredRepresentation);
        this.effectiveRepresentation = Objects.requireNonNull(effectiveRepresentation);
    }

    public Optional<ArgumentDefinition> getArgumentDefinition() {
        return Optional.of(this.argumentDef);
    }

    public QName getStatementName() {
        return this.statementName;
    }

    public Class<? extends EffectiveStatement<?, ?>> getEffectiveRepresentationClass() {
        return this.effectiveRepresentation;
    }

    public Class<? extends DeclaredStatement<?>> getDeclaredRepresentationClass() {
        return this.declaredRepresentation;
    }
}

