/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc6643.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.checkerframework.checker.regex.qual.Regex;
import org.opendaylight.yangtools.concepts.Identifier;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.yang.common.Uint32;

@Beta
public final class ObjectIdentifier
implements Identifier,
WritableObject {
    private static final long serialVersionUID = 1L;
    private static final @Regex String CHECK_OID_REGEX = "^\\d+(\\.\\d+)*$";
    private static final Pattern CHECK_OID_PATTERN = Pattern.compile("^\\d+(\\.\\d+)*$");
    private static final Pattern SPLIT_PATTERN = Pattern.compile(".", 16);
    private final int[] subIdentifiers;

    private ObjectIdentifier(int[] subIdentifiers) {
        this.subIdentifiers = subIdentifiers;
    }

    public static ObjectIdentifier of(int ... subIdentifiers) {
        return new ObjectIdentifier((int[])subIdentifiers.clone());
    }

    public static ObjectIdentifier forString(String str) {
        return new ObjectIdentifier(ObjectIdentifier.parseObjectId(str));
    }

    public int[] getSubIdentifiers() {
        return (int[])this.subIdentifiers.clone();
    }

    public IntStream streamSubIdentifiers() {
        return Arrays.stream(this.subIdentifiers);
    }

    public static ObjectIdentifier readFrom(DataInput in) throws IOException {
        int count = in.readUnsignedByte();
        Preconditions.checkArgument((count >= 0 && count <= 128 ? 1 : 0) != 0, (String)"Illegal item count %s", (int)count);
        int[] oid = new int[count];
        for (int index = 0; index < count; ++index) {
            oid[index] = in.readInt();
        }
        return new ObjectIdentifier(oid);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeByte(this.subIdentifiers.length);
        for (int i : this.subIdentifiers) {
            out.writeInt(i);
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.subIdentifiers);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ObjectIdentifier && Arrays.equals(this.subIdentifiers, ((ObjectIdentifier)obj).subIdentifiers);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.subIdentifiers[0]);
        for (int index = 1; index < this.subIdentifiers.length; ++index) {
            stringBuilder.append('.').append(this.subIdentifiers[index]);
        }
        return stringBuilder.toString();
    }

    private static int[] parseObjectId(String objectId) {
        Preconditions.checkArgument((boolean)CHECK_OID_PATTERN.matcher(objectId).matches(), (String)"Wrong format for OID: '%s'", (Object)objectId);
        String[] splitOid = SPLIT_PATTERN.split(objectId);
        Preconditions.checkArgument((splitOid.length <= 128 ? 1 : 0) != 0, (Object)"Object Identifier can have at most 128 sub-identifiers");
        int[] oid = new int[splitOid.length];
        for (int index = 0; index < splitOid.length; ++index) {
            oid[index] = Uint32.valueOf((String)splitOid[index]).intValue();
        }
        return oid;
    }
}

