/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.plugin.generator.api;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public final class GeneratedFileType {
    public static final GeneratedFileType RESOURCE = new GeneratedFileType("resource");
    public static final GeneratedFileType SOURCE = new GeneratedFileType("source");
    private static final ImmutableMap<String, GeneratedFileType> WELL_KNOWN = ImmutableMap.of((Object)RESOURCE.name(), (Object)RESOURCE, (Object)SOURCE.name(), (Object)SOURCE);
    private final String name;

    private GeneratedFileType(String name) {
        this.name = Objects.requireNonNull(name);
    }

    public static GeneratedFileType of(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        GeneratedFileType wellKnown = (GeneratedFileType)WELL_KNOWN.get((Object)name);
        return wellKnown != null ? wellKnown : new GeneratedFileType(name);
    }

    public String name() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof GeneratedFileType)) return false;
        GeneratedFileType other = (GeneratedFileType)obj;
        if (!this.name.equals(other.name)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).toString();
    }
}

