/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.plugin.generator.api;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public final class GeneratedFilePath {
    public static final char SEPARATOR = '/';
    public static final String SEPARATOR_STR = "/";
    private static final CharMatcher FS_MATCHER = CharMatcher.is((char)File.separatorChar);
    private final String path;

    private GeneratedFilePath(String path) {
        this.path = Objects.requireNonNull(path);
        Preconditions.checkArgument((!path.isEmpty() ? 1 : 0) != 0);
    }

    public static GeneratedFilePath ofPath(String path) {
        return new GeneratedFilePath(path);
    }

    public static GeneratedFilePath ofFile(File file) {
        return GeneratedFilePath.ofFilePath(file.getPath());
    }

    public static GeneratedFilePath ofFilePath(String filePath) {
        return GeneratedFilePath.ofPath(FS_MATCHER.replaceFrom((CharSequence)filePath, '/'));
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof GeneratedFilePath)) return false;
        GeneratedFilePath other = (GeneratedFilePath)obj;
        if (!this.path.equals(other.path)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("path", (Object)this.path).toString();
    }
}

