/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.plugin.generator.api;

import com.google.common.base.MoreObjects;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.plugin.generator.api.AbstractGeneratedFile;
import org.opendaylight.yangtools.plugin.generator.api.GeneratedFileLifecycle;

@NonNullByDefault
final class ByteSourceGeneratedFile
extends AbstractGeneratedFile {
    private final ByteSource body;

    ByteSourceGeneratedFile(GeneratedFileLifecycle lifecycle, ByteSource body) {
        super(lifecycle);
        this.body = Objects.requireNonNull(body);
    }

    @Override
    public void writeBody(@NonNull OutputStream output) throws IOException {
        this.body.copyTo(output);
    }

    @Override
    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("body", (Object)this.body);
    }
}

