/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.runtime.SwitchBootstraps;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.KeylessStep;
import org.opendaylight.yangtools.binding.NodeStep;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectReference;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectReferenceBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierImpl;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceImpl;
import org.opendaylight.yangtools.concepts.HierarchicalIdentifier;
import org.opendaylight.yangtools.yang.binding.IIv5;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

@Deprecated(since="14.0.0")
public sealed class InstanceIdentifier<T extends DataObject>
extends AbstractDataObjectReference<T, DataObjectStep<?>>
implements HierarchicalIdentifier<InstanceIdentifier<? extends DataObject>>
permits KeyedInstanceIdentifier {
    private static final long serialVersionUID = 3L;
    private final boolean wildcarded;

    InstanceIdentifier(Iterable<? extends @NonNull DataObjectStep<?>> steps, boolean wildcarded) {
        super(steps);
        this.wildcarded = wildcarded;
    }

    public final @NonNull Class<T> getTargetType() {
        return this.lastStep().type();
    }

    public final <N extends DataObject> @NonNull InstanceIdentifier<N> verifyTarget(Class<@NonNull N> target) {
        Verify.verify((boolean)target.equals(this.getTargetType()), (String)"Cannot adapt %s to %s", (Object)this, target);
        return this;
    }

    @Override
    public final boolean isExact() {
        return !this.wildcarded;
    }

    @Override
    @Deprecated(since="14.0.0", forRemoval=true)
    public final boolean isWildcarded() {
        return this.wildcarded;
    }

    @Override
    protected final Class<?> contract() {
        return this.wildcarded ? super.contract() : DataObjectIdentifier.class;
    }

    public final <I extends DataObject> @Nullable InstanceIdentifier<I> firstIdentifierOf(Class<@NonNull I> type) {
        int count = 1;
        for (DataObjectStep step : this.steps()) {
            if (type.equals(step.type())) {
                InstanceIdentifier<?> ret = InstanceIdentifier.internalCreate(Iterables.limit(this.steps(), (int)count));
                return ret;
            }
            ++count;
        }
        return null;
    }

    public final <N extends EntryObject<N, K>, K extends Key<N>> @Nullable K firstKeyOf(Class<@NonNull N> listItem) {
        for (DataObjectStep step : this.steps()) {
            if (!(step instanceof KeyStep)) continue;
            KeyStep keyPredicate = (KeyStep)step;
            if (!listItem.equals(step.type())) continue;
            Object ret = keyPredicate.key();
            return ret;
        }
        return null;
    }

    public final boolean contains(InstanceIdentifier<? extends DataObject> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator oit = other.steps().iterator();
        for (DataObjectStep step : this.steps()) {
            if (!oit.hasNext()) {
                return false;
            }
            if (step.equals(oit.next())) continue;
            return false;
        }
        return true;
    }

    public final boolean containsWildcarded(InstanceIdentifier<?> other) {
        Objects.requireNonNull(other, "other should not be null");
        Iterator otherSteps = other.steps().iterator();
        for (DataObjectStep step : this.steps()) {
            if (!otherSteps.hasNext()) {
                return false;
            }
            DataObjectStep otherStep = (DataObjectStep)otherSteps.next();
            if (step instanceof ExactDataObjectStep) {
                if (step.equals(otherStep)) continue;
                return false;
            }
            if (step instanceof KeylessStep) {
                KeylessStep keyless = (KeylessStep)step;
                if (keyless.matches(otherStep)) continue;
                return false;
            }
            throw new IllegalStateException("Unhandled step " + String.valueOf(step));
        }
        return true;
    }

    private <N extends DataObject> @NonNull InstanceIdentifier<N> childIdentifier(DataObjectStep<N> arg) {
        return InstanceIdentifier.trustedCreate(arg, InstanceIdentifier.concat(this.steps(), arg), this.wildcarded);
    }

    public final <N extends ChildOf<? super T>> @NonNull InstanceIdentifier<N> child(Class<@NonNull N> container) {
        return this.childIdentifier(DataObjectStep.of(container));
    }

    public final <N extends EntryObject<N, K> & ChildOf<? super T>, K extends Key<N>> @NonNull KeyedInstanceIdentifier<N, K> child(Class<@NonNull N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(new KeyStep<K, N>(listItem, listKey));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> @NonNull InstanceIdentifier<N> child(Class<@NonNull C> caze, Class<@NonNull N> container) {
        return this.childIdentifier(DataObjectStep.of(caze, container));
    }

    public final <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends EntryObject<N, K> & ChildOf<? super C>> @NonNull KeyedInstanceIdentifier<N, K> child(Class<@NonNull C> caze, Class<@NonNull N> listItem, K listKey) {
        return (KeyedInstanceIdentifier)this.childIdentifier(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    public final <A extends Augmentation<? super T>> @NonNull InstanceIdentifier<A> augmentation(Class<@NonNull A> augmentation) {
        return this.childIdentifier(new NodeStep<A>(augmentation));
    }

    @Override
    protected Object toSerialForm() {
        return new IIv5(this);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }

    @Override
    public Builder<T> toBuilder() {
        return new RegularBuilder(this);
    }

    @Override
    public DataObjectIdentifier<T> toIdentifier() {
        return this.toReference().toIdentifier();
    }

    @Override
    public final InstanceIdentifier<T> toLegacy() {
        return this;
    }

    public @NonNull DataObjectReference<T> toReference() {
        Iterable steps = this.steps();
        return this.wildcarded ? new DataObjectReferenceImpl((Iterable<? extends DataObjectStep<?>>)((Iterable<DataObjectStep<?>>)steps)) : new DataObjectIdentifierImpl(null, steps);
    }

    @Override
    @Deprecated(since="14.0.0")
    public Builder<T> builder() {
        return this.toBuilder();
    }

    public static <T extends ChildOf<? extends DataRoot<?>>> @NonNull Builder<T> builder(@NonNull Class<T> container) {
        return new RegularBuilder<T>(DataObjectStep.of(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builder(@NonNull Class<C> caze, @NonNull Class<T> container) {
        return new RegularBuilder<T>(DataObjectStep.of(caze, container));
    }

    public static <N extends EntryObject<N, K> & ChildOf<? extends DataRoot<?>>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builder(Class<N> listItem, K listKey) {
        return new KeyedBuilder<N, K>(new KeyStep<K, N>(listItem, listKey));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, N extends EntryObject<N, K> & ChildOf<? super C>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builder(@NonNull Class<C> caze, @NonNull Class<N> listItem, @NonNull K listKey) {
        return new KeyedBuilder<N, K>(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    public static <R extends DataRoot<R>, T extends ChildOf<? super R>> @NonNull Builder<T> builderOfInherited(@NonNull Class<R> root, @NonNull Class<T> container) {
        return new RegularBuilder<T>(DataObjectStep.of(container));
    }

    public static <R extends DataRoot<R>, C extends ChoiceIn<? super R> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builderOfInherited(Class<R> root, Class<C> caze, Class<T> container) {
        return new RegularBuilder<T>(DataObjectStep.of(caze, container));
    }

    public static <R extends DataRoot<R>, N extends EntryObject<N, K> & ChildOf<? super R>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builderOfInherited(@NonNull Class<R> root, @NonNull Class<N> listItem, @NonNull K listKey) {
        return new KeyedBuilder<N, K>(new KeyStep<K, N>(listItem, listKey));
    }

    public static <R extends DataRoot<R>, C extends ChoiceIn<? super R> & DataObject, N extends EntryObject<N, K> & ChildOf<? super C>, K extends Key<N>> @NonNull KeyedBuilder<N, K> builderOfInherited(Class<R> root, Class<C> caze, Class<N> listItem, K listKey) {
        return new KeyedBuilder<N, K>(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    private static @NonNull InstanceIdentifier<?> internalCreate(Iterable<? extends DataObjectStep<?>> pathArguments) {
        DataObjectStep<?> arg;
        Iterator<DataObjectStep<?>> it = Objects.requireNonNull(pathArguments, "pathArguments may not be null").iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"pathArguments may not be empty");
        boolean wildcard = false;
        do {
            Class type;
            Preconditions.checkArgument((ChildOf.class.isAssignableFrom(type = ((DataObjectStep)Verify.verifyNotNull(arg = it.next())).type()) || Augmentation.class.isAssignableFrom(type) ? 1 : 0) != 0, (String)"%s is not a valid path argument", type);
            if (arg instanceof ExactDataObjectStep) continue;
            wildcard = true;
        } while (it.hasNext());
        return InstanceIdentifier.trustedCreate(arg, pathArguments, wildcard);
    }

    public static <T extends DataObject> @NonNull InstanceIdentifier<T> unsafeOf(List<? extends DataObjectStep<?>> pathArguments) {
        return InstanceIdentifier.internalCreate(ImmutableList.copyOf(pathArguments));
    }

    public static <T extends ChildOf<? extends DataRoot<?>>> @NonNull InstanceIdentifier<T> create(Class<@NonNull T> type) {
        return InstanceIdentifier.internalCreate(ImmutableList.of(DataObjectStep.of(type)));
    }

    public static <N extends EntryObject<N, K>, K extends Key<N>> K keyOf(InstanceIdentifier<N> id) {
        Objects.requireNonNull(id);
        Preconditions.checkArgument((boolean)(id instanceof KeyedInstanceIdentifier), (String)"%s does not have a key", id);
        Key ret = ((KeyedInstanceIdentifier)id).key();
        return (K)ret;
    }

    static <N extends DataObject> @NonNull InstanceIdentifier<N> trustedCreate(DataObjectStep<?> lastStep, Iterable<? extends DataObjectStep<?>> pathArguments, boolean wildcarded) {
        DataObjectStep<?> dataObjectStep = lastStep;
        Objects.requireNonNull(dataObjectStep);
        DataObjectStep<?> dataObjectStep2 = dataObjectStep;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NodeStep.class, KeyStep.class, KeylessStep.class}, dataObjectStep2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                NodeStep cast = (NodeStep)dataObjectStep2;
                yield new InstanceIdentifier(pathArguments, wildcarded);
            }
            case 1 -> {
                KeyStep cast = (KeyStep)dataObjectStep2;
                yield new KeyedInstanceIdentifier(pathArguments, wildcarded);
            }
            case 2 -> {
                KeylessStep cast = (KeylessStep)dataObjectStep2;
                yield new InstanceIdentifier(pathArguments, true);
            }
        };
    }

    private static final class RegularBuilder<T extends DataObject>
    extends Builder<T> {
        RegularBuilder(DataObjectStep<T> item) {
            super(item);
        }

        RegularBuilder(InstanceIdentifier<T> identifier) {
            super(identifier);
        }

        private RegularBuilder(KeyedBuilder<?, ?> prev) {
            super((Builder<?>)prev);
        }

        @Override
        public InstanceIdentifier<T> build() {
            return new InstanceIdentifier(this.buildSteps(), this.wildcard());
        }

        @Override
        protected <X extends DataObject> RegularBuilder<X> append(DataObjectStep<X> step) {
            this.appendItem(step);
            return this;
        }

        @Override
        protected <X extends EntryObject<X, Y>, Y extends Key<X>> KeyedBuilder<X, Y> append(KeyStep<Y, X> item) {
            return new KeyedBuilder(this).append((KeyStep)item);
        }
    }

    public static abstract sealed class Builder<T extends DataObject>
    extends AbstractDataObjectReferenceBuilder<T>
    permits KeyedBuilder, RegularBuilder {
        Builder(Builder<?> prev) {
            super(prev);
        }

        Builder(InstanceIdentifier<T> identifier) {
            super(identifier);
        }

        Builder(DataObjectStep<?> item) {
            super(item);
        }

        Builder(ExactDataObjectStep<?> item) {
            super(item);
        }

        @Override
        public final <A extends Augmentation<? super T>> Builder<A> augmentation(Class<A> augmentation) {
            return this.append(new NodeStep<A>(augmentation));
        }

        @Override
        public final <N extends ChildOf<? super T>> Builder<N> child(Class<N> container) {
            return this.append(DataObjectStep.of(container));
        }

        @Override
        public final <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> Builder<N> child(Class<C> caze, Class<N> container) {
            return this.append(DataObjectStep.of(caze, container));
        }

        @Override
        public final <N extends EntryObject<N, K> & ChildOf<? super T>, K extends Key<N>> KeyedBuilder<N, K> child(Class<@NonNull N> listItem, K listKey) {
            return this.append(new KeyStep<K, N>(listItem, listKey));
        }

        @Override
        public final <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends EntryObject<N, K> & ChildOf<? super C>> KeyedBuilder<N, K> child(Class<C> caze, Class<N> listItem, K listKey) {
            return this.append(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
        }

        @Override
        public abstract @NonNull InstanceIdentifier<T> build();

        @Override
        protected abstract <X extends DataObject> @NonNull RegularBuilder<X> append(DataObjectStep<X> var1);

        @Override
        protected abstract <X extends EntryObject<X, Y>, Y extends Key<X>> @NonNull KeyedBuilder<X, Y> append(KeyStep<Y, X> var1);
    }

    public static final class KeyedBuilder<T extends EntryObject<T, K>, K extends Key<T>>
    extends Builder<T>
    implements DataObjectReference.Builder.WithKey<T, K> {
        KeyedBuilder(KeyStep<K, T> firstStep) {
            super((ExactDataObjectStep<?>)firstStep);
        }

        KeyedBuilder(KeyedInstanceIdentifier<T, K> identifier) {
            super(identifier);
        }

        private KeyedBuilder(RegularBuilder<?> prev) {
            super((Builder<?>)prev);
        }

        @Override
        public @NonNull KeyedInstanceIdentifier<T, K> build() {
            return new KeyedInstanceIdentifier(this.buildSteps(), this.wildcard());
        }

        @Override
        protected <X extends DataObject> @NonNull RegularBuilder<X> append(DataObjectStep<X> step) {
            return new RegularBuilder(this).append((DataObjectStep)step);
        }

        @Override
        protected <X extends EntryObject<X, Y>, Y extends Key<X>> KeyedBuilder<X, Y> append(KeyStep<Y, X> step) {
            this.appendItem((ExactDataObjectStep<?>)step);
            return this;
        }
    }
}

