/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding;

import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.InexactDataObjectStep;
import org.opendaylight.yangtools.binding.KeyAware;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.KeylessStep;
import org.opendaylight.yangtools.binding.NodeStep;

public sealed interface DataObjectStep<T extends DataObject>
extends Comparable<DataObjectStep<?>>,
Serializable
permits ExactDataObjectStep, InexactDataObjectStep {
    public static <T extends DataObject> @NonNull DataObjectStep<T> of(@NonNull Class<T> type) {
        return DataObjectStep.of(null, type);
    }

    public static <T extends DataObject, C extends ChoiceIn<?> & DataObject> @NonNull DataObjectStep<T> of(@Nullable Class<C> caze, @NonNull Class<T> type) {
        return KeyAware.class.isAssignableFrom(type) ? new KeylessStep<T>(type, caze) : new NodeStep<T>(type, caze);
    }

    public @NonNull Class<T> type();

    public @Nullable Class<? extends DataObject> caseType();

    @Override
    default public int compareTo(DataObjectStep<?> other) {
        int typeCmp = DataObjectStep.compareClasses(this.type(), other.type());
        if (typeCmp != 0) {
            return typeCmp;
        }
        Class<DataObject> caseType = this.caseType();
        Class<DataObject> otherCaseType = other.caseType();
        if (caseType == null) {
            return otherCaseType == null ? 0 : -1;
        }
        int caseCmp = otherCaseType == null ? 1 : DataObjectStep.compareClasses(caseType, otherCaseType);
        return caseCmp != 0 ? caseCmp : DataObjectStep.compareHierarchy(this, other);
    }

    private static int compareHierarchy(DataObjectStep<?> recv, DataObjectStep<?> other) {
        if (recv instanceof NodeStep) {
            if (other instanceof NodeStep) {
                return 0;
            }
            if (other instanceof KeylessStep || other instanceof KeyStep) {
                return -1;
            }
        } else if (recv instanceof KeyStep) {
            KeyStep thisAware = (KeyStep)recv;
            if (other instanceof KeyStep) {
                KeyStep otherAware = (KeyStep)other;
                Comparable thisKey = (Comparable)thisAware.key();
                return thisKey.compareTo(otherAware.key());
            }
            if (other instanceof NodeStep || other instanceof KeylessStep) {
                return 1;
            }
        } else if (recv instanceof KeylessStep) {
            if (other instanceof KeylessStep) {
                return 0;
            }
            if (other instanceof NodeStep || other instanceof KeyStep) {
                return 1;
            }
        }
        throw new IllegalStateException("Unhandled " + String.valueOf(recv) + ".compareTo(" + String.valueOf(other) + ")");
    }

    private static int compareClasses(Class<?> first, Class<?> second) {
        return first.getCanonicalName().compareTo(second.getCanonicalName());
    }
}

