/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding;

import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.ExactDataObjectStep;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyAware;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectReference;
import org.opendaylight.yangtools.binding.impl.AbstractDataObjectReferenceBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierImpl;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceBuilder;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceBuilderWithKey;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceImpl;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceWithKey;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedInstanceIdentifier;

public sealed interface DataObjectReference<T extends DataObject>
extends Immutable,
Serializable
permits DataObjectIdentifier, WithKey, AbstractDataObjectReference {
    @Deprecated(since="14.0.0")
    default public @NonNull Builder<T> builder() {
        return this.toBuilder();
    }

    public static <T extends ChildOf<? extends DataRoot<?>>> @NonNull Builder<T> builder(@NonNull Class<T> container) {
        return new DataObjectReferenceBuilder(DataObjectStep.of(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builder(@NonNull Class<C> caze, @NonNull Class<T> container) {
        return new DataObjectReferenceBuilder(DataObjectStep.of(caze, container));
    }

    public static <N extends EntryObject<N, K> & ChildOf<? extends DataRoot<?>>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builder(Class<N> listItem, K listKey) {
        return new DataObjectReferenceBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, listKey));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, N extends EntryObject<N, K> & ChildOf<? super C>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builder(@NonNull Class<C> caze, @NonNull Class<N> listItem, @NonNull K listKey) {
        return new DataObjectReferenceBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    public static <R extends DataRoot<R>, T extends ChildOf<? super R>> @NonNull Builder<T> builderOfInherited(@NonNull Class<R> root, @NonNull Class<T> container) {
        return new DataObjectReferenceBuilder(DataObjectStep.of(container));
    }

    public static <R extends DataRoot<R>, C extends ChoiceIn<? super R> & DataObject, T extends ChildOf<? super C>> @NonNull Builder<T> builderOfInherited(Class<R> root, Class<C> caze, Class<T> container) {
        return new DataObjectReferenceBuilder(DataObjectStep.of(caze, container));
    }

    public static <R extends DataRoot<R>, N extends EntryObject<N, K> & ChildOf<? super R>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builderOfInherited(@NonNull Class<R> root, @NonNull Class<N> listItem, @NonNull K listKey) {
        return new DataObjectReferenceBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, listKey));
    }

    public static <R extends DataRoot<R>, C extends ChoiceIn<? super R> & DataObject, N extends EntryObject<N, K> & ChildOf<? super C>, K extends Key<N>> @NonNull Builder.WithKey<N, K> builderOfInherited(Class<R> root, Class<C> caze, Class<N> listItem, K listKey) {
        return new DataObjectReferenceBuilderWithKey<N, K>(new KeyStep<K, N>(listItem, Objects.requireNonNull(caze), listKey));
    }

    public static @NonNull DataObjectReference<?> ofUnsafeSteps(Iterable<? extends @NonNull DataObjectStep<?>> steps) {
        return DataObjectReference.ofUnsafeSteps(ImmutableList.copyOf(steps));
    }

    public static @NonNull DataObjectReference<?> ofUnsafeSteps(List<? extends @NonNull DataObjectStep<?>> steps) {
        return DataObjectReference.ofUnsafeSteps(ImmutableList.copyOf(steps));
    }

    public static @NonNull DataObjectReference<?> ofUnsafeSteps(ImmutableList<? extends @NonNull DataObjectStep<?>> steps) {
        if (steps.stream().allMatch(ExactDataObjectStep.class::isInstance)) {
            return DataObjectIdentifierImpl.ofUnsafeSteps(steps);
        }
        return DataObjectReferenceImpl.ofUnsafeSteps(steps);
    }

    public @NonNull Iterable<? extends @NonNull DataObjectStep<?>> steps();

    public @NonNull DataObjectStep<T> lastStep();

    public @NonNull Builder<T> toBuilder();

    public @NonNull DataObjectIdentifier<T> toIdentifier();

    default public boolean isExact() {
        return false;
    }

    default public @NonNull InstanceIdentifier<T> toLegacy() {
        return InstanceIdentifier.unsafeOf(ImmutableList.copyOf(this.steps()));
    }

    @Deprecated(since="14.0.0")
    default public @NonNull Iterable<? extends @NonNull DataObjectStep<?>> getPathArguments() {
        return this.steps();
    }

    @Deprecated(since="14.0.0")
    default public boolean isWildcarded() {
        return true;
    }

    public static sealed interface Builder<T extends DataObject>
    permits WithKey, DataObjectIdentifier.Builder, AbstractDataObjectReferenceBuilder {
        public <A extends Augmentation<? super T>> @NonNull Builder<A> augmentation(@NonNull Class<A> var1);

        public <N extends ChildOf<? super T>> @NonNull Builder<N> child(@NonNull Class<N> var1);

        public <C extends ChoiceIn<? super T> & DataObject, N extends ChildOf<? super C>> @NonNull Builder<N> child(Class<C> var1, @NonNull Class<N> var2);

        public <N extends EntryObject<N, K> & ChildOf<? super T>, K extends Key<N>> @NonNull WithKey<N, K> child(@NonNull Class<@NonNull N> var1, @NonNull K var2);

        public <C extends ChoiceIn<? super T> & DataObject, K extends Key<N>, N extends EntryObject<N, K> & ChildOf<? super C>> @NonNull WithKey<N, K> child(@NonNull Class<C> var1, @NonNull Class<N> var2, @NonNull K var3);

        public @NonNull DataObjectReference<T> build();

        public static sealed interface WithKey<T extends EntryObject<T, K>, K extends Key<T>>
        extends Builder<T>
        permits DataObjectIdentifier.Builder.WithKey, DataObjectReferenceBuilderWithKey, InstanceIdentifier.KeyedBuilder {
            public org.opendaylight.yangtools.binding.DataObjectReference$WithKey<T, K> build();
        }
    }

    public static sealed interface WithKey<T extends EntryObject<T, K>, K extends Key<T>>
    extends DataObjectReference<T>,
    KeyAware<K>
    permits DataObjectIdentifier.WithKey, DataObjectReferenceWithKey, KeyedInstanceIdentifier {
        public KeyStep<K, T> lastStep();

        public Builder.WithKey<T, K> toBuilder();

        public DataObjectIdentifier.WithKey<T, K> toIdentifier();

        @Override
        default public K key() {
            return ((KeyStep)this.lastStep()).key();
        }

        @Deprecated(since="14.0.0")
        default public @NonNull K getKey() {
            return this.key();
        }
    }
}

