/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.binding;

import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierWithKey;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceWithKey;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public final class KeyedInstanceIdentifier<T extends EntryObject<T, K>, K extends Key<T>>
extends InstanceIdentifier<T>
implements DataObjectReference.WithKey<T, K> {
    private static final long serialVersionUID = 2L;

    KeyedInstanceIdentifier(Iterable<? extends DataObjectStep<?>> pathArguments, boolean wildcarded) {
        super(pathArguments, wildcarded);
    }

    @Override
    public KeyStep<K, T> lastStep() {
        return (KeyStep)KeyedInstanceIdentifier.getLast(this.steps());
    }

    @Override
    @Deprecated(since="14.0.0")
    public InstanceIdentifier.KeyedBuilder<T, K> builder() {
        return this.toBuilder();
    }

    @Override
    public KeyedInstanceIdentifier<T, K> toLegacy() {
        return this;
    }

    @Override
    public InstanceIdentifier.KeyedBuilder<T, K> toBuilder() {
        return new InstanceIdentifier.KeyedBuilder(this);
    }

    @Override
    public DataObjectIdentifier.WithKey<T, K> toIdentifier() {
        return this.toReference().toIdentifier();
    }

    public DataObjectReference.WithKey<T, K> toReference() {
        Iterable steps = this.steps();
        return this.isExact() ? new DataObjectIdentifierWithKey(null, steps) : new DataObjectReferenceWithKey((Iterable<? extends DataObjectStep<?>>)((Iterable<DataObjectStep<?>>)steps));
    }
}

