/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.lib;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.OpaqueData;
import org.opendaylight.yangtools.binding.OpaqueObject;

@Beta
public abstract class AbstractOpaqueObject<T extends OpaqueObject<T>>
implements OpaqueObject<T> {
    @Override
    public final int hashCode() {
        return 31 * this.implementedInterface().hashCode() + this.valueHashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof OpaqueObject)) return false;
        OpaqueObject other = (OpaqueObject)obj;
        if (!this.implementedInterface().equals(other.implementedInterface())) return false;
        if (!this.valueEquals((OpaqueData)other.getValue())) return false;
        return true;
    }

    public final String toString() {
        return this.addToStringAttributes(MoreObjects.toStringHelper((Object)this).add("implementedInterface", this.implementedInterface())).toString();
    }

    protected MoreObjects.ToStringHelper addToStringAttributes(MoreObjects.ToStringHelper helper) {
        return helper.add("value", this.getValue());
    }

    protected boolean valueEquals(@NonNull OpaqueData<?> otherValue) {
        return ((OpaqueData)this.getValue()).equals(otherValue);
    }

    protected int valueHashCode() {
        return ((OpaqueData)this.getValue()).hashCode();
    }
}

