/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.impl;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataObjectStep;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyStep;
import org.opendaylight.yangtools.binding.KeylessStep;
import org.opendaylight.yangtools.binding.NodeStep;
import org.opendaylight.yangtools.binding.impl.AppendIterable;
import org.opendaylight.yangtools.binding.impl.DataObjectIdentifierImpl;
import org.opendaylight.yangtools.binding.impl.DataObjectReferenceImpl;
import org.opendaylight.yangtools.binding.impl.ORv1;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public abstract sealed class AbstractDataObjectReference<T extends DataObject, S extends DataObjectStep<?>>
implements DataObjectReference<T>
permits DataObjectIdentifierImpl, DataObjectReferenceImpl, InstanceIdentifier {
    private static final long serialVersionUID = 1L;
    private static final String TRIM_STRING = "org.opendaylight.yang.gen.v1.";
    private static final int TRIM_LENGTH = "org.opendaylight.yang.gen.v1.".length();
    private final @NonNull Iterable<? extends @NonNull S> steps;

    protected AbstractDataObjectReference(Iterable<? extends @NonNull S> steps) {
        this.steps = Objects.requireNonNull(steps);
    }

    @Override
    public final Iterable<? extends @NonNull S> steps() {
        return this.steps;
    }

    @Override
    public DataObjectStep<T> lastStep() {
        return (DataObjectStep)AbstractDataObjectReference.getLast(this.steps);
    }

    @Override
    public <N extends EntryObject<N, K>, K extends Key<N>> @Nullable K firstKeyOf(Class<@NonNull N> listItem) {
        Class<EntryObject> item = listItem.asSubclass(EntryObject.class);
        for (DataObjectStep step : this.steps) {
            if (!(step instanceof KeyStep)) continue;
            KeyStep keyStep = (KeyStep)step;
            if (!item.equals(step.type())) continue;
            Object ret = keyStep.key();
            return ret;
        }
        return null;
    }

    public final int hashCode() {
        int hash = 1;
        for (DataObjectStep step : this.steps) {
            hash = 31 * hash + step.hashCode();
        }
        return hash;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof AbstractDataObjectReference)) return false;
        AbstractDataObjectReference other = (AbstractDataObjectReference)obj;
        if (!Iterables.elementsEqual(this.steps, other.steps)) return false;
        return true;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.contract().getSimpleName()).append("[\n");
        String prevPackage = ".";
        for (DataObjectStep step : this.steps) {
            prevPackage = AbstractDataObjectReference.appendStep(sb, prevPackage, step);
        }
        return sb.append(']').toString();
    }

    private static @NonNull String appendStep(StringBuilder sb, String prevPackage, DataObjectStep<?> step) {
        DataObjectStep<?> dataObjectStep = step;
        Objects.requireNonNull(dataObjectStep);
        DataObjectStep<?> dataObjectStep2 = dataObjectStep;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KeyStep.class, KeylessStep.class, NodeStep.class}, dataObjectStep2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                KeyStep cast = (KeyStep)dataObjectStep2;
                yield AbstractDataObjectReference.appendStep(sb, prevPackage, cast);
            }
            case 1 -> {
                KeylessStep cast = (KeylessStep)dataObjectStep2;
                yield AbstractDataObjectReference.appendStep(sb, prevPackage, cast);
            }
            case 2 -> {
                NodeStep cast = (NodeStep)dataObjectStep2;
                yield AbstractDataObjectReference.appendStep(sb, prevPackage, cast);
            }
        };
    }

    private static @NonNull String appendStep(StringBuilder sb, String prevPackage, KeyStep<?, ?> step) {
        String ret = AbstractDataObjectReference.appendStep(sb, prevPackage, step.caseType(), step.type());
        sb.append('[').append(step.key()).append("]\n");
        return ret;
    }

    private static @NonNull String appendStep(StringBuilder sb, String prevPackage, KeylessStep<?> step) {
        String ret = AbstractDataObjectReference.appendStep(sb, prevPackage, step.caseType(), step.type());
        sb.append("(any)\n");
        return ret;
    }

    private static @NonNull String appendStep(StringBuilder sb, String prevPackage, NodeStep<?> step) {
        String ret = AbstractDataObjectReference.appendStep(sb, prevPackage, step.caseType(), step.type());
        sb.append('\n');
        return ret;
    }

    private static @NonNull String appendStep(StringBuilder sb, String prevPackage, @Nullable Class<? extends DataObject> caseType, Class<? extends DataObject> type) {
        sb.append("  ");
        if (caseType != null) {
            AbstractDataObjectReference.appendClass(sb.append('<'), prevPackage, caseType);
            sb.append('>');
        }
        return AbstractDataObjectReference.appendClass(sb, prevPackage, type);
    }

    private static @NonNull String appendClass(StringBuilder sb, String trim, Class<? extends DataObject> type) {
        String fqpn = type.getPackageName();
        if (fqpn.startsWith(trim)) {
            sb.append("... ").append(fqpn, trim.length(), fqpn.length());
        } else if (fqpn.startsWith(TRIM_STRING)) {
            sb.append("@ ").append(fqpn, TRIM_LENGTH, fqpn.length());
        } else {
            sb.append(fqpn);
        }
        sb.append('.').append(type.getSimpleName());
        return fqpn + ".";
    }

    protected @NonNull Class<?> contract() {
        return DataObjectReference.class;
    }

    protected static final <T> @NonNull T getLast(Iterable<?> steps) {
        Iterable<?> iterable = steps;
        Objects.requireNonNull(iterable);
        Iterable<?> iterable2 = iterable;
        int n = 0;
        return (T)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AppendIterable.class, List.class}, iterable2, n)) {
            case 0 -> {
                AppendIterable append = (AppendIterable)iterable2;
                yield append.last();
            }
            case 1 -> {
                List list = (List)iterable2;
                yield list.getLast();
            }
            default -> Iterables.getLast(steps);
        });
    }

    protected final void throwNSE() throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    protected final Object writeReplace() throws ObjectStreamException {
        return this.toSerialForm();
    }

    protected @NonNull Object toSerialForm() {
        return new ORv1(this);
    }

    @NonNullByDefault
    protected static final <T> Iterable<? extends T> concat(Iterable<? extends T> others, T last) {
        return new AppendIterable<T>(others, last);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.throwNSE();
    }

    private void readObjectNoData() throws ObjectStreamException {
        this.throwNSE();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.throwNSE();
    }
}

