/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.contract;

import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;

public enum StatementNamespace {
    FEATURE("$F"),
    IDENTITY("$I"),
    TYPEDEF("$T"),
    GROUPING("$G"),
    YANG_DATA("$YD"),
    AUGMENT("$AU", true),
    ACTION("$AC", true),
    ANYDATA("$AD", true),
    ANYXML("$AX", true),
    CASE("$CA", true),
    CHOICE("$CH", true),
    CONTAINER("$CO", true),
    INPUT("$IP", true),
    LEAF("$LE", true),
    LIST("$LI", true),
    LEAF_LIST("$LL", true),
    KEY("$KE", true),
    NOTIFICATION("$NO", true),
    OUTPUT("$OU", true),
    RPC("$RP", true),
    DATA_ROOT("$D", true);

    private final @NonNull String suffix;
    private final boolean resistant;

    private StatementNamespace(String suffix) {
        this(suffix, false);
    }

    private StatementNamespace(String suffix, boolean resistant) {
        Verify.verify((!suffix.isEmpty() ? 1 : 0) != 0);
        this.suffix = Objects.requireNonNull(suffix);
        this.resistant = resistant;
    }

    public @NonNull String suffix() {
        return this.suffix;
    }

    public boolean resistant() {
        return this.resistant;
    }
}

