/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.contract;

import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.common.Revision;
import org.opendaylight.yangtools.yang.common.YangDataName;

@Beta
public final class Naming {
    public static final @NonNull String VERSION = "0.6";
    public static final ImmutableSet<String> JAVA_RESERVED_WORDS = ImmutableSet.of((Object)"abstract", (Object)"assert", (Object)"boolean", (Object)"break", (Object)"byte", (Object)"case", (Object[])new String[]{"catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "_", "false", "true", "null", "var", "yield", "record"});
    public static final @NonNull String PACKAGE_PREFIX = "org.opendaylight.yang.gen.v1";
    public static final @NonNull String SVC_PACKAGE_PREFIX = "org.opendaylight.yang.svc.v1";
    public static final @NonNull String DATA_ROOT_SUFFIX = "Data";
    public static final @NonNull String BUILDER_SUFFIX = "Builder";
    public static final @NonNull String KEY_SUFFIX = "Key";
    public static final @NonNull String RPC_INPUT_SUFFIX = "Input";
    public static final @NonNull String RPC_OUTPUT_SUFFIX = "Output";
    public static final @NonNull String NAME_STATIC_FIELD_NAME = "NAME";
    public static final @NonNull String QNAME_STATIC_FIELD_NAME = "QNAME";
    public static final @NonNull String VALUE_STATIC_FIELD_NAME = "VALUE";
    public static final @NonNull String AUGMENTATION_FIELD = "augmentation";
    private static final Splitter CAMEL_SPLITTER = Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)" _.-/").precomputed()).omitEmptyStrings().trimResults();
    private static final Pattern COLON_SLASH_SLASH = Pattern.compile("://", 16);
    private static final String QUOTED_DOT = Matcher.quoteReplacement(".");
    private static final Splitter DOT_SPLITTER = Splitter.on((char)'.');
    public static final @NonNull String MODULE_INFO_CLASS_NAME = "YangModuleInfoImpl";
    public static final @NonNull String MODULE_INFO_QNAMEOF_METHOD_NAME = "qnameOf";
    public static final @NonNull String MODULE_INFO_YANGDATANAMEOF_METHOD_NAME = "yangDataNameOf";
    public static final @NonNull String MODEL_BINDING_PROVIDER_CLASS_NAME = "YangModelBindingProviderImpl";
    public static final @NonNull String AUGMENTABLE_AUGMENTATION_NAME = "augmentation";
    public static final @NonNull String KEY_AWARE_KEY_NAME = "key";
    public static final @NonNull String BINDING_CONTRACT_IMPLEMENTED_INTERFACE_NAME = "implementedInterface";
    public static final @NonNull String BINDING_HASHCODE_NAME = "bindingHashCode";
    public static final @NonNull String BINDING_EQUALS_NAME = "bindingEquals";
    public static final @NonNull String BINDING_TO_STRING_NAME = "bindingToString";
    public static final @NonNull String ACTION_INVOKE_NAME = "invoke";
    public static final @NonNull String RPC_INVOKE_NAME = "invoke";
    public static final @NonNull String SCALAR_TYPE_OBJECT_GET_VALUE_NAME = "getValue";
    public static final @NonNull String GETTER_PREFIX = "get";
    public static final @NonNull String NONNULL_PREFIX = "nonnull";
    public static final @NonNull String REQUIRE_PREFIX = "require";
    private static final Interner<String> PACKAGE_INTERNER = Interners.newWeakInterner();
    private static final Pattern ROOT_PACKAGE_PATTERN = Pattern.compile("(org.opendaylight.yang.(gen|svc).v1.[a-z0-9_\\.]*?\\.(?:rev[0-9][0-9][0-1][0-9][0-3][0-9]|norev))");

    private Naming() {
    }

    public static @NonNull String getServicePackageName(QNameModule module) {
        StringBuilder packageNameBuilder = new StringBuilder().append(SVC_PACKAGE_PREFIX).append('.');
        return Naming.getRootPackageName(packageNameBuilder, module);
    }

    public static @NonNull String getRootPackageName(QName module) {
        return Naming.getRootPackageName(module.getModule());
    }

    public static @NonNull String getRootPackageName(QNameModule module) {
        StringBuilder packageNameBuilder = new StringBuilder().append(PACKAGE_PREFIX).append('.');
        return Naming.getRootPackageName(packageNameBuilder, module);
    }

    private static @NonNull String getRootPackageName(StringBuilder builder, QNameModule module) {
        Revision revision;
        String namespace = module.namespace().toString();
        namespace = COLON_SLASH_SLASH.matcher(namespace).replaceAll(QUOTED_DOT);
        char[] chars = namespace.toCharArray();
        block3: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '#': 
                case '$': 
                case '\'': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': {
                    chars[i] = 46;
                    continue block3;
                }
            }
        }
        builder.append(chars);
        if (chars[chars.length - 1] != '.') {
            builder.append('.');
        }
        if ((revision = module.revision()) != null) {
            String rev = revision.toString();
            Verify.verify((rev.length() == 10 ? 1 : 0) != 0, (String)"Revision.toString() resulted in unexpected '%s'", (Object)rev);
            builder.append("rev").append(rev, 2, 4).append(rev, 5, 7).append(rev.substring(8));
        } else {
            builder.append("norev");
        }
        return Naming.normalizePackageName(builder.toString());
    }

    public static @NonNull String rootToServicePackageName(String rootPackageName) {
        Matcher match = ROOT_PACKAGE_PATTERN.matcher(rootPackageName);
        Preconditions.checkArgument((boolean)match.find(), (String)"Package name '%s' does not match required pattern '%s'", (Object)rootPackageName, (Object)ROOT_PACKAGE_PATTERN);
        return Naming.getModelRootPackageName(rootPackageName.replace(PACKAGE_PREFIX, SVC_PACKAGE_PREFIX));
    }

    public static @NonNull String normalizePackageName(String packageName) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String p : DOT_SPLITTER.split((CharSequence)packageName.toLowerCase(Locale.ENGLISH))) {
            if (first) {
                first = false;
            } else {
                builder.append('.');
            }
            if (Character.isDigit(p.charAt(0)) || JAVA_RESERVED_WORDS.contains((Object)p)) {
                builder.append('_');
            }
            builder.append(p);
        }
        return (String)PACKAGE_INTERNER.intern((Object)builder.toString());
    }

    public static @NonNull String getClassName(String localName) {
        return Naming.toFirstUpper(Naming.toCamelCase(localName));
    }

    public static @NonNull String getClassName(QName name) {
        return Naming.toFirstUpper(Naming.toCamelCase(name.getLocalName()));
    }

    public static @NonNull String getMethodName(String yangIdentifier) {
        return Naming.toFirstLower(Naming.toCamelCase(yangIdentifier));
    }

    public static @NonNull String getMethodName(QName name) {
        return Naming.getMethodName(name.getLocalName());
    }

    public static @NonNull String getGetterMethodName(String localName) {
        return GETTER_PREFIX + Naming.toFirstUpper(Naming.getPropertyName(localName));
    }

    public static @NonNull String getGetterMethodName(QName name) {
        return GETTER_PREFIX + Naming.getGetterSuffix(name);
    }

    public static boolean isGetterMethodName(String methodName) {
        return methodName.startsWith(GETTER_PREFIX);
    }

    public static @NonNull String getGetterMethodForNonnull(String methodName) {
        Preconditions.checkArgument((boolean)Naming.isNonnullMethodName(methodName));
        return GETTER_PREFIX + methodName.substring(NONNULL_PREFIX.length());
    }

    public static @NonNull String getNonnullMethodName(String localName) {
        return NONNULL_PREFIX + Naming.toFirstUpper(Naming.getPropertyName(localName));
    }

    public static boolean isNonnullMethodName(String methodName) {
        return methodName.startsWith(NONNULL_PREFIX);
    }

    public static @NonNull String getGetterMethodForRequire(String methodName) {
        Preconditions.checkArgument((boolean)Naming.isRequireMethodName(methodName));
        return GETTER_PREFIX + methodName.substring(REQUIRE_PREFIX.length());
    }

    public static @NonNull String getRequireMethodName(String localName) {
        return REQUIRE_PREFIX + Naming.toFirstUpper(Naming.getPropertyName(localName));
    }

    public static boolean isRequireMethodName(String methodName) {
        return methodName.startsWith(REQUIRE_PREFIX);
    }

    public static @NonNull String getGetterSuffix(QName name) {
        String candidate = Naming.toFirstUpper(Naming.toCamelCase(name.getLocalName()));
        return "Class".equals(candidate) ? "XmlClass" : candidate;
    }

    public static @NonNull String getPropertyName(String yangIdentifier) {
        String potential = Naming.toFirstLower(Naming.toCamelCase(yangIdentifier));
        if ("class".equals(potential)) {
            return "xmlClass";
        }
        return potential;
    }

    public static @NonNull String getUnionLeafrefMemberName(String unionClassSimpleName, String referencedClassSimpleName) {
        return Objects.requireNonNull(referencedClassSimpleName) + Objects.requireNonNull(unionClassSimpleName) + "Value";
    }

    private static @NonNull String toCamelCase(String rawString) {
        StringBuilder builder = new StringBuilder();
        for (String comp : CAMEL_SPLITTER.split((CharSequence)rawString)) {
            builder.append(Naming.toFirstUpper(comp));
        }
        return Naming.checkNumericPrefix(builder.toString());
    }

    private static @NonNull String checkNumericPrefix(String rawString) {
        if (rawString.isEmpty()) {
            return rawString;
        }
        char firstChar = rawString.charAt(0);
        return firstChar >= '0' && firstChar <= '9' ? "_" + rawString : rawString;
    }

    public static @NonNull String toFirstUpper(@NonNull String str) {
        if (str.isEmpty()) {
            return str;
        }
        if (Character.isUpperCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toUpperCase(Locale.ENGLISH);
        }
        return str.substring(0, 1).toUpperCase(Locale.ENGLISH) + str.substring(1);
    }

    private static @NonNull String toFirstLower(@NonNull String str) {
        if (str.isEmpty()) {
            return str;
        }
        if (Character.isLowerCase(str.charAt(0))) {
            return str;
        }
        if (str.length() == 1) {
            return str.toLowerCase(Locale.ENGLISH);
        }
        return str.substring(0, 1).toLowerCase(Locale.ENGLISH) + str.substring(1);
    }

    public static @NonNull String getModelRootPackageName(String packageName) {
        Preconditions.checkArgument((packageName.startsWith(PACKAGE_PREFIX) || packageName.startsWith(SVC_PACKAGE_PREFIX) ? 1 : 0) != 0, (String)"Package name not starting with %s, is: %s", (Object)PACKAGE_PREFIX, (Object)packageName);
        Matcher match = ROOT_PACKAGE_PATTERN.matcher(packageName);
        Preconditions.checkArgument((boolean)match.find(), (String)"Package name '%s' does not match required pattern '%s'", (Object)packageName, (Object)ROOT_PACKAGE_PATTERN);
        return match.group(0);
    }

    public static BiMap<String, String> mapEnumAssignedNames(Collection<String> assignedNames) {
        HashBiMap javaToYang = HashBiMap.create((int)assignedNames.size());
        boolean valid = true;
        for (String name : assignedNames) {
            String mappedName;
            Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
            if (javaToYang.containsValue((Object)name) || Naming.isValidJavaIdentifier(mappedName = Naming.getClassName(name)) && javaToYang.forcePut((Object)mappedName, (Object)name) == null) continue;
            valid = false;
            break;
        }
        if (!valid) {
            javaToYang.clear();
            for (String name : assignedNames) {
                javaToYang.put((Object)Naming.mapEnumAssignedName(name), (Object)name);
            }
        }
        return javaToYang.inverse();
    }

    public static String mapYangDataName(YangDataName templateName) {
        return Naming.mapEnumAssignedName(templateName.name());
    }

    private static boolean isValidJavaIdentifier(String str) {
        return !str.isEmpty() && !JAVA_RESERVED_WORDS.contains((Object)str) && Character.isJavaIdentifierStart(str.codePointAt(0)) && str.codePoints().skip(1L).allMatch(Character::isJavaIdentifierPart);
    }

    private static String mapEnumAssignedName(String assignedName) {
        Preconditions.checkArgument((!assignedName.isEmpty() ? 1 : 0) != 0);
        if (assignedName.indexOf(36) == -1 && Naming.isValidJavaIdentifier(assignedName)) {
            return assignedName;
        }
        StringBuilder sb = new StringBuilder().append('$');
        assignedName.codePoints().forEachOrdered(codePoint -> {
            if (codePoint == 36 || !Character.isJavaIdentifierPart(codePoint)) {
                sb.append('$').append(Integer.toHexString(codePoint).toUpperCase(Locale.ROOT)).append('$');
            } else {
                sb.appendCodePoint(codePoint);
            }
        });
        return sb.toString();
    }
}

