/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.runtime.spi;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.meta.YangModuleInfo;
import org.opendaylight.yangtools.binding.runtime.api.ModuleInfoSnapshot;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.source.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.api.source.YangTextSource;
import org.opendaylight.yangtools.yang.model.repo.api.MissingSchemaSourceException;
import org.opendaylight.yangtools.yang.model.spi.source.DelegatedYangTextSource;

final class DefaultModuleInfoSnapshot
implements ModuleInfoSnapshot {
    private final ImmutableMap<SourceIdentifier, YangModuleInfo> moduleInfos;
    private final ImmutableMap<String, ClassLoader> classLoaders;
    private final @NonNull EffectiveModelContext modelContext;

    DefaultModuleInfoSnapshot(EffectiveModelContext modelContext, Map<SourceIdentifier, YangModuleInfo> moduleInfos, Map<String, ClassLoader> classLoaders) {
        this.modelContext = Objects.requireNonNull(modelContext);
        this.moduleInfos = ImmutableMap.copyOf(moduleInfos);
        this.classLoaders = ImmutableMap.copyOf(classLoaders);
    }

    public EffectiveModelContext modelContext() {
        return this.modelContext;
    }

    public YangTextSource yangTextSource(SourceIdentifier sourceId) {
        YangModuleInfo info = (YangModuleInfo)this.moduleInfos.get((Object)sourceId);
        return info == null ? null : new DelegatedYangTextSource(sourceId, info.getYangTextCharSource());
    }

    public YangTextSource getYangTextSource(SourceIdentifier sourceId) throws MissingSchemaSourceException {
        YangTextSource source = this.yangTextSource(sourceId);
        if (source == null) {
            throw new MissingSchemaSourceException(sourceId, "No source registered");
        }
        return source;
    }

    public <T> Class<T> loadClass(String fullyQualifiedName) throws ClassNotFoundException {
        String packageName = Naming.getModelRootPackageName((String)fullyQualifiedName);
        ClassLoader loader = (ClassLoader)this.classLoaders.get((Object)packageName);
        if (loader == null) {
            throw new ClassNotFoundException("Package " + packageName + " not found");
        }
        Class<?> loaded = loader.loadClass(fullyQualifiedName);
        return loaded;
    }
}

