/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.ri;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.Action;
import org.opendaylight.yangtools.binding.Augmentable;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.BaseIdentity;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataContainer;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.EntryObject;
import org.opendaylight.yangtools.binding.Grouping;
import org.opendaylight.yangtools.binding.InstanceNotification;
import org.opendaylight.yangtools.binding.Key;
import org.opendaylight.yangtools.binding.KeyedListAction;
import org.opendaylight.yangtools.binding.KeyedListNotification;
import org.opendaylight.yangtools.binding.Notification;
import org.opendaylight.yangtools.binding.NotificationBody;
import org.opendaylight.yangtools.binding.OpaqueObject;
import org.opendaylight.yangtools.binding.Rpc;
import org.opendaylight.yangtools.binding.RpcInput;
import org.opendaylight.yangtools.binding.RpcOutput;
import org.opendaylight.yangtools.binding.ScalarTypeObject;
import org.opendaylight.yangtools.binding.YangData;
import org.opendaylight.yangtools.binding.YangFeature;
import org.opendaylight.yangtools.binding.annotations.RoutingContext;
import org.opendaylight.yangtools.binding.contract.BuiltInType;
import org.opendaylight.yangtools.binding.model.api.ConcreteType;
import org.opendaylight.yangtools.binding.model.api.Constant;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.ParameterizedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResult;
import org.opendaylight.yangtools.yang.common.YangDataName;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;

public final class BindingTypes {
    public static final ConcreteType BASE_IDENTITY = Types.typeForBuiltIn(BuiltInType.IDENTITYREF);
    public static final ConcreteType DATA_CONTAINER = Types.typeForClass(DataContainer.class);
    public static final ConcreteType DATA_OBJECT = Types.typeForClass(DataObject.class);
    public static final ConcreteType GROUPING = Types.typeForClass(Grouping.class);
    public static final ConcreteType QNAME = Types.typeForClass(QName.class);
    public static final ConcreteType RPC_INPUT = Types.typeForClass(RpcInput.class);
    public static final ConcreteType RPC_OUTPUT = Types.typeForClass(RpcOutput.class);
    public static final ConcreteType SCALAR_TYPE_OBJECT = Types.typeForClass(ScalarTypeObject.class);
    public static final ConcreteType BITS_TYPE_OBJECT = Types.typeForBuiltIn(BuiltInType.BITS);
    public static final ConcreteType UNION_TYPE_OBJECT = Types.typeForBuiltIn(BuiltInType.UNION);
    public static final ConcreteType YANG_DATA_NAME = Types.typeForClass(YangDataName.class);
    public static final JavaTypeName ROUTING_CONTEXT = JavaTypeName.create(RoutingContext.class);
    @VisibleForTesting
    static final ConcreteType AUGMENTABLE = Types.typeForClass(Augmentable.class);
    @VisibleForTesting
    static final ConcreteType AUGMENTATION = Types.typeForClass(Augmentation.class);
    @VisibleForTesting
    static final ConcreteType ENTRY_OBJECT = Types.typeForClass(EntryObject.class);
    @VisibleForTesting
    static final ConcreteType KEY = Types.typeForClass(Key.class);
    private static final ConcreteType ACTION = Types.typeForClass(Action.class);
    private static final ConcreteType CHILD_OF = Types.typeForClass(ChildOf.class);
    private static final ConcreteType CHOICE_IN = Types.typeForClass(ChoiceIn.class);
    private static final ConcreteType DATA_ROOT = Types.typeForClass(DataRoot.class);
    private static final ConcreteType INSTANCE_NOTIFICATION = Types.typeForClass(InstanceNotification.class);
    private static final ConcreteType KEYED_LIST_ACTION = Types.typeForClass(KeyedListAction.class);
    private static final ConcreteType KEYED_LIST_NOTIFICATION = Types.typeForClass(KeyedListNotification.class);
    private static final ConcreteType NOTIFICATION = Types.typeForClass(Notification.class);
    private static final ConcreteType NOTIFICATION_BODY = Types.typeForClass(NotificationBody.class);
    private static final ConcreteType OBJECT_REFERENCE = Types.typeForClass(DataObjectIdentifier.class);
    private static final ConcreteType OBJECT_REFERENCE_WITH_KEY = Types.typeForClass(DataObjectIdentifier.WithKey.class);
    private static final ConcreteType OPAQUE_OBJECT = Types.typeForClass(OpaqueObject.class);
    private static final ConcreteType RPC = Types.typeForClass(Rpc.class);
    private static final ConcreteType RPC_RESULT = Types.typeForClass(RpcResult.class);
    private static final ConcreteType YANG_FEATURE = Types.typeForClass(YangFeature.class);
    private static final ConcreteType YANG_DATA = Types.typeForClass(YangData.class);

    private BindingTypes() {
    }

    public static ParameterizedType action(Type parent, Type input, Type output) {
        return Types.parameterizedTypeFor(ACTION, BindingTypes.objectIdentifier(parent), input, output);
    }

    public static ParameterizedType keyedListAction(Type parent, Type keyType, Type input, Type output) {
        return Types.parameterizedTypeFor(KEYED_LIST_ACTION, keyType, parent, input, output);
    }

    public static ParameterizedType notification(Type concreteType) {
        return Types.parameterizedTypeFor(NOTIFICATION, concreteType);
    }

    public static ParameterizedType notificationBody(Type concreteType) {
        return Types.parameterizedTypeFor(NOTIFICATION_BODY, concreteType);
    }

    public static ParameterizedType instanceNotification(Type concreteType, Type parent) {
        return Types.parameterizedTypeFor(INSTANCE_NOTIFICATION, concreteType, parent);
    }

    public static ParameterizedType keyedListNotification(Type concreteType, Type parent, Type keyType) {
        return Types.parameterizedTypeFor(KEYED_LIST_NOTIFICATION, concreteType, parent, keyType);
    }

    public static @NonNull ParameterizedType augmentable(Type type) {
        return Types.parameterizedTypeFor(AUGMENTABLE, type);
    }

    public static @NonNull ParameterizedType augmentation(Type type) {
        return Types.parameterizedTypeFor(AUGMENTATION, type);
    }

    public static ParameterizedType childOf(Type type) {
        return Types.parameterizedTypeFor(CHILD_OF, type);
    }

    public static ParameterizedType dataRoot(Type type) {
        return Types.parameterizedTypeFor(DATA_ROOT, type);
    }

    public static ParameterizedType choiceIn(Type type) {
        return Types.parameterizedTypeFor(CHOICE_IN, type);
    }

    public static ParameterizedType key(Type type) {
        return Types.parameterizedTypeFor(KEY, type);
    }

    public static ParameterizedType entryObject(Type type, Type keyType) {
        return Types.parameterizedTypeFor(ENTRY_OBJECT, type, keyType);
    }

    public static ParameterizedType objectIdentifier(Type type) {
        return Types.parameterizedTypeFor(OBJECT_REFERENCE, type);
    }

    public static ParameterizedType objectIdentifierWithKey(Type type, Type keyType) {
        return Types.parameterizedTypeFor(OBJECT_REFERENCE_WITH_KEY, type, keyType);
    }

    public static ParameterizedType opaqueObject(Type type) {
        return Types.parameterizedTypeFor(OPAQUE_OBJECT, type);
    }

    public static @NonNull ParameterizedType rpc(Type input, Type output) {
        return Types.parameterizedTypeFor(RPC, input, output);
    }

    public static ParameterizedType rpcResult(Type type) {
        return Types.parameterizedTypeFor(RPC_RESULT, type);
    }

    public static ParameterizedType scalarTypeObject(Type type) {
        return Types.parameterizedTypeFor(SCALAR_TYPE_OBJECT, type);
    }

    public static ParameterizedType yangData(Type concreteType) {
        return Types.parameterizedTypeFor(YANG_DATA, concreteType);
    }

    public static ParameterizedType yangFeature(Type concreteType, Type parent) {
        return Types.parameterizedTypeFor(YANG_FEATURE, concreteType, parent);
    }

    public static boolean isBitsType(Type type) {
        GeneratedTransferObject gto;
        return type instanceof GeneratedTransferObject && BindingTypes.isBitsType(gto = (GeneratedTransferObject)type);
    }

    public static boolean isBitsType(GeneratedTransferObject gto) {
        return gto.isTypedef() && gto.getBaseType() instanceof BitsTypeDefinition;
    }

    public static boolean isIdentityType(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            for (Constant constant : generated.getConstantDefinitions()) {
                if (!"VALUE".equals(constant.getName()) || !BaseIdentity.class.equals(constant.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNotificationBody(Type type) {
        if (type instanceof GeneratedType) {
            GeneratedType generated = (GeneratedType)type;
            for (Type iface : generated.getImplements()) {
                ParameterizedType parameterized;
                if (!(iface instanceof ParameterizedType) || !NOTIFICATION_BODY.equals((parameterized = (ParameterizedType)iface).getRawType())) continue;
                return true;
            }
        }
        return false;
    }

    public static @Nullable Type extractAugmentationTarget(ParameterizedType type) {
        return AUGMENTATION.equals(type.getRawType()) ? BindingTypes.onlyTypeArgument(type) : null;
    }

    public static @Nullable Type extractAugmentableTarget(ParameterizedType type) {
        Type arg;
        Type[] args;
        Type rawType = type.getRawType();
        if (AUGMENTABLE.equals(rawType)) {
            return BindingTypes.onlyTypeArgument(type);
        }
        if (ENTRY_OBJECT.equals(rawType) && (args = type.getActualTypeArguments()).length == 2 && (arg = args[0]) != null) {
            return arg;
        }
        return null;
    }

    public static @Nullable Type extractKeyType(ParameterizedType type) {
        return KEY.equals(type.getRawType()) ? BindingTypes.onlyTypeArgument(type) : null;
    }

    private static Type onlyTypeArgument(ParameterizedType type) {
        Type arg;
        Type[] args = type.getActualTypeArguments();
        if (args.length == 1 && (arg = args[0]) != null) {
            return arg;
        }
        return null;
    }

    @Beta
    public static @Nullable Type extractYangFeatureDataRoot(GeneratedTransferObject gto) {
        Type[] args;
        ParameterizedType param;
        Type type;
        List<Type> impls;
        if (!gto.isAbstract() && gto.getSuperType() == null && (impls = gto.getImplements()).size() == 1 && (type = impls.getFirst()) instanceof ParameterizedType && YANG_FEATURE.equals((param = (ParameterizedType)type).getRawType()) && (args = param.getActualTypeArguments()).length == 2) {
            return args[1];
        }
        return null;
    }
}

