/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
public final class TypeMemberComment
implements Immutable {
    private final String contractDescription;
    private final String referenceDescription;
    private final String typeSignature;

    public TypeMemberComment(String contractDescription, String referenceDescription, String typeSignature) {
        this.contractDescription = contractDescription;
        this.referenceDescription = referenceDescription;
        this.typeSignature = typeSignature;
    }

    public @Nullable String contractDescription() {
        return this.contractDescription;
    }

    public @Nullable String referenceDescription() {
        return this.referenceDescription;
    }

    public @Nullable String typeSignature() {
        return this.typeSignature;
    }

    public static @NonNull TypeMemberComment contractOf(String contractDescription) {
        return new TypeMemberComment(Objects.requireNonNull(contractDescription), null, null);
    }

    public static @NonNull TypeMemberComment referenceOf(String referenceDescription) {
        return new TypeMemberComment(null, Objects.requireNonNull(referenceDescription), null);
    }

    public int hashCode() {
        return Objects.hash(this.contractDescription, this.referenceDescription, this.typeSignature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof TypeMemberComment)) return false;
        TypeMemberComment other = (TypeMemberComment)obj;
        if (!Objects.equals(this.contractDescription, other.contractDescription)) return false;
        if (!Objects.equals(this.referenceDescription, other.referenceDescription)) return false;
        if (!Objects.equals(this.typeSignature, other.typeSignature)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("contract", (Object)this.contractDescription).add("reference", (Object)this.referenceDescription).add("type", (Object)this.typeSignature).toString();
    }
}

