/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.model.api;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;

@Beta
public final class Restrictions {
    private static final @NonNull Restrictions EMPTY = new Restrictions(null, null, (List<PatternConstraint>)ImmutableList.of());
    private final LengthConstraint lengthConstraint;
    private final RangeConstraint<?> rangeConstraint;
    private final ImmutableList<PatternConstraint> patternConstraints;

    private Restrictions(LengthConstraint lengthConstraint, RangeConstraint<?> rangeConstraint, List<PatternConstraint> patternConstraints) {
        this.lengthConstraint = lengthConstraint;
        this.rangeConstraint = rangeConstraint;
        this.patternConstraints = ImmutableList.copyOf(patternConstraints);
    }

    public static @NonNull Restrictions empty() {
        return EMPTY;
    }

    public static @NonNull Restrictions of(@Nullable LengthConstraint lengthConstraint) {
        return lengthConstraint == null ? EMPTY : new Restrictions(lengthConstraint, null, (List<PatternConstraint>)ImmutableList.of());
    }

    public static @NonNull Restrictions of(@Nullable RangeConstraint<?> rangeConstraint) {
        return rangeConstraint == null ? EMPTY : new Restrictions(null, rangeConstraint, (List<PatternConstraint>)ImmutableList.of());
    }

    public static @NonNull Restrictions of(List<PatternConstraint> patternConstraints, @Nullable LengthConstraint lengthConstraint) {
        return patternConstraints.isEmpty() && lengthConstraint == null ? EMPTY : new Restrictions(lengthConstraint, null, patternConstraints);
    }

    public Optional<LengthConstraint> getLengthConstraint() {
        return Optional.ofNullable(this.lengthConstraint);
    }

    public List<PatternConstraint> getPatternConstraints() {
        return this.patternConstraints;
    }

    public Optional<RangeConstraint<?>> getRangeConstraint() {
        return Optional.ofNullable(this.rangeConstraint);
    }

    public boolean isEmpty() {
        return this.lengthConstraint == null && this.rangeConstraint == null && this.patternConstraints.isEmpty();
    }
}

