/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeReference;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultTypedefRuntimeType;
import org.opendaylight.yangtools.binding.model.api.Constant;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.YangSourceDefinition;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTOBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.binding.runtime.api.TypedefRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class TypedefGenerator
extends AbstractTypeObjectGenerator<TypedefEffectiveStatement, TypedefRuntimeType> {
    private List<AbstractTypeObjectGenerator<?, ?>> derivedGenerators = null;

    TypedefGenerator(TypedefEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.TYPEDEF;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterTypedef((QName)((TypedefEffectiveStatement)this.statement()).argument());
    }

    void addDerivedGenerator(AbstractTypeObjectGenerator<?, ?> derivedGenerator) {
        if (this.derivedGenerators == null) {
            this.derivedGenerators = new ArrayList(4);
        }
        this.derivedGenerators.add(Objects.requireNonNull(derivedGenerator));
    }

    @Override
    void bindDerivedGenerators(TypeReference reference) {
        if (this.derivedGenerators != null) {
            for (AbstractTypeObjectGenerator<?, ?> derived : this.derivedGenerators) {
                derived.bindTypeDefinition(reference);
            }
        }
        this.derivedGenerators = List.of();
    }

    @Override
    ClassPlacement classPlacementImpl() {
        return ClassPlacement.TOP_LEVEL;
    }

    @Override
    TypeDefinition<?> extractTypeDefinition() {
        return ((TypedefEffectiveStatement)this.statement()).getTypeDefinition();
    }

    @Override
    GeneratedTransferObject createDerivedType(TypeBuilderFactory builderFactory, GeneratedTransferObject baseType) {
        GeneratedTOBuilder builder = builderFactory.newGeneratedTOBuilder(this.typeName());
        builder.setTypedef(true);
        builder.setExtendsType(baseType);
        builder.setIsUnion(baseType.isUnionType());
        builder.setRestrictions(this.computeRestrictions());
        YangSourceDefinition.of((ModuleEffectiveStatement)((ModuleEffectiveStatement)this.currentModule().statement()), this.statement()).ifPresent(arg_0 -> ((GeneratedTOBuilder)builder).setYangSourceDefinition(arg_0));
        TypeDefinition typedef = ((TypedefEffectiveStatement)this.statement()).getTypeDefinition();
        TypedefGenerator.annotateDeprecatedIfNecessary((DocumentedNode.WithStatus)typedef, (AnnotableTypeBuilder)builder);
        TypedefGenerator.addStringRegExAsConstant(builder, TypedefGenerator.resolveRegExpressions(typedef));
        TypedefGenerator.addUnits(builder, typedef);
        if (typedef instanceof BitsTypeDefinition) {
            BitsTypeDefinition bits = (BitsTypeDefinition)typedef;
            TypedefGenerator.addValidBits(builder, bits, baseType);
        }
        TypedefGenerator.makeSerializable(builder);
        return builder.build();
    }

    private static void addValidBits(GeneratedTOBuilder builder, BitsTypeDefinition typedef, GeneratedTransferObject baseType) {
        BitsTypeDefinition baseDef = (BitsTypeDefinition)Verify.verifyNotNull((Object)TypedefGenerator.baseBitsDefinition(baseType), (String)"Could not find definition in %s", (Object[])new Object[]{baseType});
        Collection myBits = typedef.getBits();
        if (myBits.size() != baseDef.getBits().size()) {
            builder.addConstant((Type)Types.immutableSetTypeFor((Type)Types.STRING), "VALID_NAMES", (Object)typedef);
        }
    }

    private static BitsTypeDefinition baseBitsDefinition(GeneratedTransferObject gto) {
        for (GeneratedTransferObject wlk = gto; wlk != null; wlk = wlk.getSuperType()) {
            for (Constant constant : wlk.getConstantDefinitions()) {
                if (!"VALID_NAMES".equals(constant.getName())) continue;
                return (BitsTypeDefinition)constant.getValue();
            }
        }
        return null;
    }

    @Override
    TypedefRuntimeType createExternalRuntimeType(Type type) {
        return new DefaultTypedefRuntimeType(TypedefGenerator.verifyGeneratedType(type), (TypedefEffectiveStatement)this.statement());
    }

    @Override
    TypedefRuntimeType createInternalRuntimeType(AugmentResolver resolver, TypedefEffectiveStatement statement, Type type) {
        throw new UnsupportedOperationException("Should never be called");
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }
}

