/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.contract.Naming;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeSchemaTreeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultListRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.MethodSignature;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.KeyRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.ListRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.Ordering;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.KeyEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class ListGenerator
extends CompositeSchemaTreeGenerator<ListEffectiveStatement, ListRuntimeType> {
    private final @Nullable KeyGenerator keyGen;

    ListGenerator(ListEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.keyGen = statement.findFirstEffectiveSubstatement(KeyEffectiveStatement.class).map(key -> new KeyGenerator((KeyEffectiveStatement)key, parent, this)).orElse(null);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.LIST;
    }

    @Nullable KeyGenerator keyGenerator() {
        return this.keyGen;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterDataTree((QName)((ListEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        this.addImplementsChildOf(builder);
        this.addUsesInterfaces(builder, builderFactory);
        ListGenerator.addConcreteInterfaceMethods(builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        KeyGenerator local = this.keyGen;
        if (local != null) {
            GeneratedType keyType = local.getGeneratedType(builderFactory);
            builder.addImplementsType((Type)BindingTypes.entryObject((Type)builder, (Type)keyType));
            ((MethodSignatureBuilder)builder.addMethod("key").setReturnType((Type)keyType)).addAnnotation(OVERRIDE_ANNOTATION);
        } else {
            ListGenerator.addAugmentable(builder);
        }
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    private @Nullable KeyRuntimeType keyRuntimeType() {
        KeyGenerator local = this.keyGen;
        return local != null ? (KeyRuntimeType)local.getRuntimeType() : null;
    }

    @Override
    Type methodReturnType(TypeBuilderFactory builderFactory) {
        Type generatedType = super.methodReturnType(builderFactory);
        KeyGenerator local = this.keyGen;
        if (local != null && ((ListEffectiveStatement)this.statement()).ordering() == Ordering.SYSTEM) {
            return Types.mapTypeFor((Type)local.getGeneratedType(builderFactory), (Type)generatedType);
        }
        return Types.listTypeFor((Type)generatedType);
    }

    @Override
    MethodSignatureBuilder constructGetter(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        MethodSignatureBuilder ret = super.constructGetter(builder, returnType).setMechanics(MethodSignature.ValueMechanics.NULLIFY_EMPTY);
        MethodSignatureBuilder nonnull = ((MethodSignatureBuilder)builder.addMethod(Naming.getNonnullMethodName((String)this.localName().getLocalName())).setReturnType(returnType)).setDefault(true);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)nonnull);
        return ret;
    }

    @Override
    CompositeRuntimeTypeBuilder<ListEffectiveStatement, ListRuntimeType> createBuilder(ListEffectiveStatement statement) {
        return new CompositeRuntimeTypeBuilder<ListEffectiveStatement, ListRuntimeType>(statement){

            @Override
            ListRuntimeType build(GeneratedType type, ListEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                return new DefaultListRuntimeType(type, statement, children, augments, ListGenerator.this.keyRuntimeType());
            }
        };
    }
}

