/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.ri.Types;

abstract sealed class TypeReference {
    TypeReference() {
    }

    static @NonNull TypeReference leafRef(@Nullable AbstractTypeObjectGenerator<?, ?> referencedGenerator) {
        return referencedGenerator == null ? UnresolvedLeafref.INSTANCE : new ResolvedLeafref(referencedGenerator);
    }

    static @NonNull TypeReference leafRef(@NonNull IllegalArgumentException cause) {
        return new FailedLeafref(cause);
    }

    static @NonNull TypeReference identityRef(List<IdentityGenerator> referencedGenerators) {
        return new Identityref(referencedGenerators);
    }

    abstract @NonNull Type methodReturnType(@NonNull TypeBuilderFactory var1);

    private static final class UnresolvedLeafref
    extends Leafref {
        static final @NonNull UnresolvedLeafref INSTANCE = new UnresolvedLeafref();

        private UnresolvedLeafref() {
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            return Types.objectType();
        }
    }

    static final class ResolvedLeafref
    extends Leafref {
        private final AbstractTypeObjectGenerator<?, ?> referencedGenerator;

        private ResolvedLeafref(AbstractTypeObjectGenerator<?, ?> referencedGenerator) {
            this.referencedGenerator = Objects.requireNonNull(referencedGenerator);
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            return this.referencedGenerator.methodReturnElementType(builderFactory);
        }
    }

    private static final class FailedLeafref
    extends Leafref {
        private final IllegalArgumentException cause;

        FailedLeafref(IllegalArgumentException cause) {
            this.cause = Objects.requireNonNull(cause);
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            throw new UnsupportedOperationException("Cannot ascertain type", this.cause);
        }
    }

    private static final class Identityref
    extends TypeReference {
        private final List<IdentityGenerator> referencedGenerators;
        private Type returnType;

        Identityref(List<IdentityGenerator> referencedGenerators) {
            this.referencedGenerators = Objects.requireNonNull(referencedGenerators);
        }

        @Override
        Type methodReturnType(TypeBuilderFactory builderFactory) {
            if (this.returnType == null) {
                this.returnType = (Type)this.referencedGenerators.stream().map(gen -> gen.getGeneratedType(builderFactory)).findFirst().orElseThrow();
            }
            return this.returnType;
        }
    }

    static abstract sealed class Leafref
    extends TypeReference
    permits ResolvedLeafref, UnresolvedLeafref, FailedLeafref {
        private Leafref() {
        }
    }
}

