/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import java.util.List;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractInvokableGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ClassPlacement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.InvokableRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultRpcRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.model.ri.Types;
import org.opendaylight.yangtools.binding.runtime.api.RpcRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;

final class RpcGenerator
extends AbstractInvokableGenerator<RpcEffectiveStatement, RpcRuntimeType> {
    RpcGenerator(RpcEffectiveStatement statement, ModuleGenerator parent) {
        super(statement, parent);
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.RPC;
    }

    @Override
    ClassPlacement classPlacement() {
        return ClassPlacement.TOP_LEVEL;
    }

    @Override
    void addImplementedType(TypeBuilderFactory builderFactory, GeneratedTypeBuilder builder, GeneratedType input, GeneratedType output) {
        builder.addImplementsType((Type)BindingTypes.rpc((Type)input, (Type)output));
        ((MethodSignatureBuilder)builder.addMethod("invoke").setAbstract(true).addParameter((Type)input, "input").setReturnType((Type)Types.listenableFutureTypeFor((Type)BindingTypes.rpcResult((Type)output)))).addAnnotation(OVERRIDE_ANNOTATION);
    }

    @Override
    CompositeRuntimeTypeBuilder<RpcEffectiveStatement, RpcRuntimeType> createBuilder(RpcEffectiveStatement statement) {
        return new InvokableRuntimeTypeBuilder<RpcEffectiveStatement, RpcRuntimeType>(this, statement){

            @Override
            RpcRuntimeType build(GeneratedType generatedType, RpcEffectiveStatement statement, List<RuntimeType> childTypes) {
                return new DefaultRpcRuntimeType(generatedType, statement, childTypes);
            }
        };
    }
}

