/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultAnydataRuntimeType;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultAnyxmlRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.AnydataRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.AnyxmlRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.OpaqueRuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnresolvedQName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract class OpaqueObjectGenerator<S extends DataTreeEffectiveStatement<?>, R extends OpaqueRuntimeType>
extends AbstractExplicitGenerator<S, R> {
    OpaqueObjectGenerator(S statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterDataTree((QName)((DataTreeEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.opaqueObject((Type)builder));
        OpaqueObjectGenerator.defaultImplementedInterace(builder);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        ModuleGenerator module = this.currentModule();
        module.addQNameConstant((GeneratedTypeBuilderBase<?>)builder, this.localName());
        builderFactory.addCodegenInformation(module, (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        builder.setModuleName(((UnresolvedQName.Unqualified)((ModuleEffectiveStatement)module.statement()).argument()).getLocalName());
        return builder.build();
    }

    @Override
    void constructRequire(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        this.constructRequireImpl(builder, returnType);
    }

    @Override
    final R createExternalRuntimeType(Type type) {
        return this.createExternalRuntimeType(OpaqueObjectGenerator.verifyGeneratedType(type));
    }

    abstract @NonNull R createExternalRuntimeType(@NonNull GeneratedType var1);

    @Override
    final R createInternalRuntimeType(AugmentResolver resolver, S statement, Type type) {
        return this.createInternalRuntimeType(statement, OpaqueObjectGenerator.verifyGeneratedType(type));
    }

    abstract @NonNull R createInternalRuntimeType(@NonNull S var1, @NonNull GeneratedType var2);

    static final class Anyxml
    extends OpaqueObjectGenerator<AnyxmlEffectiveStatement, AnyxmlRuntimeType> {
        Anyxml(AnyxmlEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
            super(statement, parent);
        }

        @Override
        StatementNamespace namespace() {
            return StatementNamespace.ANYXML;
        }

        @Override
        AnyxmlRuntimeType createExternalRuntimeType(GeneratedType type) {
            return new DefaultAnyxmlRuntimeType(type, (AnyxmlEffectiveStatement)this.statement());
        }

        @Override
        AnyxmlRuntimeType createInternalRuntimeType(AnyxmlEffectiveStatement statement, GeneratedType type) {
            return new DefaultAnyxmlRuntimeType(type, statement);
        }
    }

    static final class Anydata
    extends OpaqueObjectGenerator<AnydataEffectiveStatement, AnydataRuntimeType> {
        Anydata(AnydataEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
            super(statement, parent);
        }

        @Override
        StatementNamespace namespace() {
            return StatementNamespace.ANYDATA;
        }

        @Override
        AnydataRuntimeType createExternalRuntimeType(GeneratedType type) {
            return new DefaultAnydataRuntimeType(type, (AnydataEffectiveStatement)this.statement());
        }

        @Override
        AnydataRuntimeType createInternalRuntimeType(AnydataEffectiveStatement statement, GeneratedType type) {
            return new DefaultAnydataRuntimeType(type, statement);
        }
    }
}

