/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.VerifyException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.yangtools.binding.contract.StatementNamespace;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.rt.DefaultGroupingRuntimeType;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.AnnotableTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.AugmentRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.GroupingRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

final class GroupingGenerator
extends AbstractCompositeGenerator<GroupingEffectiveStatement, GroupingRuntimeType> {
    private List<AbstractCompositeGenerator<?, ?>> users;

    GroupingGenerator(GroupingEffectiveStatement statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
    }

    void addUser(AbstractCompositeGenerator<?, ?> user) {
        if (this.users == null) {
            this.users = new ArrayList();
            for (GroupingGenerator grouping : this.groupings()) {
                grouping.addUser(this);
            }
        }
        this.users.add(user);
    }

    boolean hasUser() {
        return this.users != null;
    }

    void freezeUsers() {
        this.users = this.users == null ? List.of() : this.users.stream().distinct().collect(Collectors.toUnmodifiableList());
    }

    @Override
    StatementNamespace namespace() {
        return StatementNamespace.GROUPING;
    }

    @Override
    void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterGrouping((QName)((GroupingEffectiveStatement)this.statement()).argument());
    }

    @Override
    GeneratedType createTypeImpl(TypeBuilderFactory builderFactory) {
        GeneratedTypeBuilder builder = builderFactory.newGeneratedTypeBuilder(this.typeName());
        builder.addImplementsType((Type)BindingTypes.GROUPING);
        this.addUsesInterfaces(builder, builderFactory);
        this.addGetterMethods(builder, builderFactory);
        this.annotateDeprecatedIfNecessary((AnnotableTypeBuilder)builder);
        builderFactory.addCodegenInformation(this.currentModule(), (EffectiveStatement<?, ?>)this.statement(), (GeneratedTypeBuilderBase<?>)builder);
        return builder.build();
    }

    @Override
    void addAsGetterMethod(GeneratedTypeBuilderBase<?> builder, TypeBuilderFactory builderFactory) {
    }

    @Override
    CompositeRuntimeTypeBuilder<GroupingEffectiveStatement, GroupingRuntimeType> createBuilder(GroupingEffectiveStatement statement) {
        List<AbstractCompositeGenerator<?, ?>> local = this.users;
        if (local == null) {
            throw new VerifyException(String.valueOf(this) + " has unresolved users");
        }
        final List vectors = local.stream().map(AbstractExplicitGenerator::getRuntimeType).distinct().collect(Collectors.toUnmodifiableList());
        return new CompositeRuntimeTypeBuilder<GroupingEffectiveStatement, GroupingRuntimeType>(this, statement){

            @Override
            GroupingRuntimeType build(GeneratedType type, GroupingEffectiveStatement statement, List<RuntimeType> children, List<AugmentRuntimeType> augments) {
                if (augments.isEmpty()) {
                    return new DefaultGroupingRuntimeType(type, statement, children, vectors);
                }
                throw new VerifyException("Unexpected augments " + String.valueOf(augments));
            }
        };
    }
}

