/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.Stopwatch;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractDependentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeAwareGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentRequirement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.yangtools.binding.generator.impl.reactor.Generator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.LinkageProgress;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveStatementEquivalent;
import org.opendaylight.yangtools.yang.model.api.PathExpression;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.spi.ModuleDependencySort;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratorReactor
extends GeneratorContext
implements Mutable {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratorReactor.class);
    private final Deque<Iterable<? extends Generator>> stack = new ArrayDeque<Iterable<? extends Generator>>();
    private final @NonNull Map<QNameModule, ModuleGenerator> generators;
    private final @NonNull List<ModuleGenerator> children;
    private final @NonNull SchemaInferenceStack inferenceStack;
    private State state = State.INITIALIZED;

    public GeneratorReactor(EffectiveModelContext context) {
        super(context);
        this.inferenceStack = SchemaInferenceStack.of((EffectiveModelContext)context);
        this.children = ModuleDependencySort.sort((Collection)context.getModules()).stream().map(EffectiveStatementEquivalent::asEffectiveStatement).map(ModuleGenerator::new).collect(Collectors.toUnmodifiableList());
        this.generators = Maps.uniqueIndex(this.children, gen -> ((ModuleEffectiveStatement)gen.statement()).localQNameModule());
    }

    public @NonNull Map<QNameModule, ModuleGenerator> execute(TypeBuilderFactory builderFactory) {
        boolean haveUnresolved;
        Stopwatch sw;
        block15: {
            boolean progress;
            switch (this.state.ordinal()) {
                case 0: {
                    this.state = State.EXECUTING;
                    break;
                }
                case 2: {
                    return this.generators;
                }
                case 1: {
                    throw new IllegalStateException("Cannot resume partial execution");
                }
                default: {
                    throw new IllegalStateException("Unhandled state" + String.valueOf((Object)this.state));
                }
            }
            sw = Stopwatch.createStarted();
            this.linkUsesDependencies(this.children);
            ArrayList<AugmentRequirement> augments = new ArrayList<AugmentRequirement>();
            for (ModuleGenerator module : this.children) {
                for (Generator gen : module) {
                    if (!(gen instanceof ModuleAugmentGenerator)) continue;
                    ModuleAugmentGenerator moduleGen = (ModuleAugmentGenerator)gen;
                    augments.add(moduleGen.startLinkage(this));
                }
            }
            for (ModuleGenerator module : this.children) {
                module.startUsesAugmentLinkage(augments);
            }
            LOG.trace("Processing linkage of {} augment generators", (Object)augments.size());
            for (ModuleGenerator module : this.children) {
                Verify.verify((boolean)module.linkOriginalGenerator(), (String)"Module %s failed to link", (Object)module);
            }
            ArrayList<ModuleGenerator> unlinkedModules = new ArrayList<ModuleGenerator>(this.children);
            do {
                progress = GeneratorReactor.progressAndClean(unlinkedModules, AbstractCompositeGenerator::linkOriginalGeneratorRecursive) | GeneratorReactor.progressAndClean(augments, AugmentRequirement::resolve);
                if (augments.isEmpty() && unlinkedModules.isEmpty()) break block15;
            } while (progress);
            VerifyException ex = new VerifyException("Failed to make progress on linking of original generators");
            for (AugmentRequirement augment : augments) {
                ex.addSuppressed((Throwable)new IllegalStateException(String.valueOf(augment) + " is incomplete"));
            }
            for (ModuleGenerator module : unlinkedModules) {
                ex.addSuppressed((Throwable)new IllegalStateException(String.valueOf(module) + " remains unlinked"));
            }
            throw ex;
        }
        this.linkDependencies(this.children);
        this.resolveGroupingUsers();
        GeneratorReactor.freezeGroupingUsers(this.children);
        this.bindTypeDefinition(this.children);
        ArrayList<CollisionDomain> domains = new ArrayList<CollisionDomain>();
        this.collectCollisionDomains(domains, this.children);
        do {
            haveUnresolved = false;
            for (CollisionDomain domain : domains) {
                if (!domain.findSolution()) continue;
                haveUnresolved = true;
            }
        } while (haveUnresolved);
        for (ModuleGenerator module : this.children) {
            module.ensureType(builderFactory);
        }
        LOG.debug("Processed {} modules in {}", (Object)this.generators.size(), (Object)sw);
        this.state = State.FINISHED;
        return this.generators;
    }

    private void collectCollisionDomains(List<CollisionDomain> result, Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            generator.ensureMember();
            this.collectCollisionDomains(result, generator);
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            AbstractCompositeGenerator compositeGen = (AbstractCompositeGenerator)generator;
            result.add(compositeGen.domain());
        }
    }

    @Override
    <E extends EffectiveStatement<QName, ?>, G extends AbstractExplicitGenerator<E, ?>> G resolveTreeScoped(Class<G> type, QName argument) {
        block5: {
            block4: {
                LOG.trace("Searching for tree-scoped argument {} at {}", (Object)argument, this.stack);
                Iterable<? extends Generator> last = this.stack.getLast();
                if (!(last instanceof ModuleGenerator)) {
                    throw new VerifyException("Unexpected last stack item " + String.valueOf(last));
                }
                ModuleGenerator lastModule = (ModuleGenerator)last;
                if (!argument.getModule().equals((Object)((ModuleEffectiveStatement)lastModule.statement()).localQNameModule())) break block4;
                for (Iterable<? extends Generator> ancestor : this.stack) {
                    for (Generator generator : ancestor) {
                        AbstractExplicitGenerator cast;
                        if (!type.isInstance(generator) || !argument.equals((cast = (AbstractExplicitGenerator)type.cast(generator)).statement().argument())) continue;
                        LOG.trace("Found matching {}", (Object)generator);
                        return (G)cast;
                    }
                }
                break block5;
            }
            ModuleGenerator module = this.generators.get(argument.getModule());
            if (module == null) break block5;
            for (Generator child : module) {
                AbstractExplicitGenerator abstractExplicitGenerator;
                if (!type.isInstance(child) || !argument.equals((abstractExplicitGenerator = (AbstractExplicitGenerator)type.cast(child)).statement().argument())) continue;
                LOG.trace("Found matching {}", (Object)child);
                return (G)abstractExplicitGenerator;
            }
        }
        throw new IllegalStateException("Could not find " + String.valueOf(type) + " argument " + String.valueOf(argument) + " in " + String.valueOf(this.stack));
    }

    @Override
    ModuleGenerator resolveModule(QNameModule namespace) {
        ModuleGenerator module = this.generators.get(Objects.requireNonNull(namespace));
        if (module == null) {
            throw new IllegalStateException("Failed to find module for " + String.valueOf(namespace));
        }
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    AbstractTypeObjectGenerator<?, ?> resolveLeafref(PathExpression path) {
        LOG.trace("Resolving path {}", (Object)path);
        Verify.verify((boolean)this.inferenceStack.isEmpty(), (String)"Unexpected data tree state %s", (Object)this.inferenceStack);
        try {
            Iterator<Iterable<? extends Generator>> it = this.stack.descendingIterator();
            Verify.verify((boolean)it.hasNext(), (String)"Unexpected empty stack", (Object[])new Object[0]);
            it.next();
            while (it.hasNext()) {
                Iterable<? extends Generator> item = it.next();
                if (item instanceof Generator) {
                    Generator generator = (Generator)item;
                    generator.pushToInference(this.inferenceStack);
                    continue;
                }
                throw new VerifyException("Unexpected stack item " + String.valueOf(item));
            }
            AbstractTypeAwareGenerator<?, ?, ?> abstractTypeAwareGenerator = this.inferenceStack.inGrouping() ? this.lenientResolveLeafref(path) : this.strictResolvePath(path);
            return abstractTypeAwareGenerator;
        }
        finally {
            this.inferenceStack.clear();
        }
    }

    private @NonNull AbstractTypeAwareGenerator<?, ?, ?> strictResolvePath(@NonNull PathExpression path) {
        try {
            this.inferenceStack.resolvePathExpression(path);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Failed to find leafref target " + path.getOriginalString(), e);
        }
        return this.mapToGenerator();
    }

    private @Nullable AbstractTypeAwareGenerator<?, ?, ?> lenientResolveLeafref(@NonNull PathExpression path) {
        try {
            this.inferenceStack.resolvePathExpression(path);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Ignoring unresolved path {}", (Object)path, (Object)e);
            return null;
        }
        return this.mapToGenerator();
    }

    private @NonNull AbstractTypeAwareGenerator<?, ?, ?> mapToGenerator() {
        List stmtPath;
        ModuleEffectiveStatement module = this.inferenceStack.currentModule();
        ModuleGenerator gen = (ModuleGenerator)Verify.verifyNotNull((Object)this.generators.get(module.localQNameModule()), (String)"Cannot find generator for %s", (Object[])new Object[]{module});
        AbstractExplicitGenerator<?, ?> found = gen.findGenerator(stmtPath = this.inferenceStack.toInference().statementPath());
        if (found instanceof AbstractTypeAwareGenerator) {
            AbstractTypeAwareGenerator typeAware = (AbstractTypeAwareGenerator)found;
            return typeAware;
        }
        throw new VerifyException("Statements " + String.valueOf(stmtPath) + " resulted in unexpected " + String.valueOf(found));
    }

    private void linkUsesDependencies(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            AbstractCompositeGenerator composite = (AbstractCompositeGenerator)generator;
            LOG.trace("Visiting composite {}", (Object)composite);
            this.stack.push(composite);
            composite.linkUsesDependencies(this);
            this.linkUsesDependencies(composite);
            this.stack.pop();
        }
    }

    private static <T> boolean progressAndClean(List<T> items, Function<T, LinkageProgress> function) {
        boolean progress = false;
        Iterator<T> it = items.iterator();
        while (it.hasNext()) {
            T item = it.next();
            LinkageProgress tmp = function.apply(item);
            if (tmp == LinkageProgress.NONE) {
                LOG.debug("No progress made linking {}", item);
                continue;
            }
            progress = true;
            if (tmp == LinkageProgress.DONE) {
                LOG.debug("Finished linking {}", item);
                it.remove();
                continue;
            }
            LOG.debug("Progress made linking {}", item);
        }
        return progress;
    }

    private void linkDependencies(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            if (generator instanceof AbstractDependentGenerator) {
                AbstractDependentGenerator dependent = (AbstractDependentGenerator)generator;
                dependent.linkDependencies(this);
                continue;
            }
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            this.stack.push(generator);
            this.linkDependencies(generator);
            this.stack.pop();
        }
    }

    private void bindTypeDefinition(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            this.stack.push(generator);
            if (generator instanceof AbstractTypeObjectGenerator) {
                AbstractTypeObjectGenerator typeObject = (AbstractTypeObjectGenerator)generator;
                typeObject.bindTypeDefinition(this);
            } else if (generator instanceof AbstractCompositeGenerator) {
                this.bindTypeDefinition(generator);
            }
            this.stack.pop();
        }
    }

    private void resolveGroupingUsers() {
        int processed;
        HashSet<GroupingGenerator> remaining = new HashSet<GroupingGenerator>();
        for (ModuleGenerator module : this.children) {
            module.linkUsedGroupings(remaining);
        }
        LOG.debug("Grouping pass 1 found {} groupings", (Object)remaining.size());
        HashSet<GroupingGenerator> found = new HashSet<GroupingGenerator>();
        int passes = 2;
        do {
            processed = 0;
            Iterator<GroupingGenerator> it = remaining.iterator();
            while (it.hasNext()) {
                GroupingGenerator next = it.next();
                if (!next.hasUser()) continue;
                it.remove();
                next.linkUsedGroupings(found);
                ++processed;
            }
            int foundSize = found.size();
            LOG.debug("Grouping pass {} processed {} and found {} grouping(s)", new Object[]{passes, processed, foundSize});
            if (foundSize != 0) {
                remaining.addAll(found);
                remaining.clear();
            }
            ++passes;
        } while (processed != 0);
        LOG.debug("Grouping usage completed after {} pass(es) with unused {} grouping(s)", (Object)passes, (Object)remaining.size());
    }

    private static void freezeGroupingUsers(Iterable<? extends Generator> parent) {
        for (Generator generator : parent) {
            if (!(generator instanceof AbstractCompositeGenerator)) continue;
            AbstractCompositeGenerator composite = (AbstractCompositeGenerator)generator;
            if (composite instanceof GroupingGenerator) {
                GroupingGenerator grouping = (GroupingGenerator)composite;
                grouping.freezeUsers();
            }
            GeneratorReactor.freezeGroupingUsers(composite);
        }
    }

    private static enum State {
        INITIALIZED,
        EXECUTING,
        FINISHED;

    }
}

