/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractCompositeGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractTypeObjectGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.yangtools.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeReference;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.JavaTypeName;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.api.type.builder.MethodSignatureBuilder;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.odlext.model.api.ContextReferenceEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.TypeAware;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.util.SchemaInferenceStack;

abstract class AbstractTypeAwareGenerator<T extends DataTreeEffectiveStatement<?>, R extends RuntimeType, G extends AbstractTypeAwareGenerator<T, R, G>>
extends AbstractTypeObjectGenerator<T, R> {
    private IdentityGenerator contextType;

    AbstractTypeAwareGenerator(T statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        Verify.verify((boolean)(statement instanceof TypeAware), (String)"Unexpected statement %s", statement);
    }

    @Override
    final void pushToInference(SchemaInferenceStack dataTree) {
        dataTree.enterDataTree((QName)((DataTreeEffectiveStatement)this.statement()).argument());
    }

    @Override
    final void bindDerivedGenerators(TypeReference reference) {
    }

    @Override
    final void bindTypeDefinition(GeneratorContext context) {
        super.bindTypeDefinition(context);
        this.contextType = ((DataTreeEffectiveStatement)this.statement()).findFirstEffectiveSubstatementArgument(ContextReferenceEffectiveStatement.class).map(context::resolveIdentity).orElse(null);
    }

    @Override
    final TypeDefinition<?> extractTypeDefinition() {
        DataTreeEffectiveStatement stmt = (DataTreeEffectiveStatement)this.statement();
        Verify.verify((boolean)(stmt instanceof TypedDataSchemaNode), (String)"Unexpected statement %s", (Object)stmt);
        return ((TypedDataSchemaNode)stmt).getType();
    }

    @Override
    final JavaTypeName createTypeName() {
        return this.getParent().typeName().createEnclosed(this.assignedName(), "$");
    }

    @Override
    final GeneratedTransferObject createDerivedType(TypeBuilderFactory builderFactory, GeneratedTransferObject baseType) {
        throw new UnsupportedOperationException();
    }

    @Override
    final MethodSignatureBuilder constructGetter(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        MethodSignatureBuilder ret = super.constructGetter(builder, returnType);
        if (this.contextType != null) {
            ret.addAnnotation(BindingTypes.ROUTING_CONTEXT).addParameter("value", this.contextType.typeName().toString() + ".class");
        }
        return ret;
    }

    @Override
    final void constructRequire(GeneratedTypeBuilderBase<?> builder, Type returnType) {
        this.constructRequireImpl(builder, returnType);
    }
}

