/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.binding.generator.impl.reactor;

import com.google.common.base.Verify;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AbstractExplicitGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ActionGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentRequirement;
import org.opendaylight.yangtools.binding.generator.impl.reactor.AugmentResolver;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CaseGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ChoiceGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CollisionDomain;
import org.opendaylight.yangtools.binding.generator.impl.reactor.CompositeRuntimeTypeBuilder;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ContainerGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.FeatureGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.Generator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GeneratorContext;
import org.opendaylight.yangtools.binding.generator.impl.reactor.GroupingGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.IdentityGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.InputGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.InstanceNotificationGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.KeyGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.KeyedListNotificationGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.LeafGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.LeafListGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.LinkageProgress;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ListGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.MatchStrategy;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.ModuleGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.NotificationBodyGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.NotificationGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.OpaqueObjectGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.OriginalLink;
import org.opendaylight.yangtools.binding.generator.impl.reactor.OutputGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.RpcGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypeBuilderFactory;
import org.opendaylight.yangtools.binding.generator.impl.reactor.TypedefGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.UsesAugmentGenerator;
import org.opendaylight.yangtools.binding.generator.impl.reactor.YangDataGenerator;
import org.opendaylight.yangtools.binding.model.api.Enumeration;
import org.opendaylight.yangtools.binding.model.api.GeneratedTransferObject;
import org.opendaylight.yangtools.binding.model.api.GeneratedType;
import org.opendaylight.yangtools.binding.model.api.Type;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.yangtools.binding.model.api.type.builder.GeneratedTypeBuilderBase;
import org.opendaylight.yangtools.binding.model.ri.BindingTypes;
import org.opendaylight.yangtools.binding.runtime.api.CompositeRuntimeType;
import org.opendaylight.yangtools.binding.runtime.api.RuntimeType;
import org.opendaylight.yangtools.rfc8040.model.api.YangDataEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AddedByUsesAware;
import org.opendaylight.yangtools.yang.model.api.CopyableNode;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ActionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnydataEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AnyxmlEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.AugmentEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.CaseEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ChoiceEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContainerEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.FeatureEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.GroupingEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.IdentityEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.InputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.LeafListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ListEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.NotificationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OutputEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.RpcEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaTreeEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.UsesEffectiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompositeGenerator<S extends EffectiveStatement<?, ?>, R extends CompositeRuntimeType>
extends AbstractExplicitGenerator<S, R> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCompositeGenerator.class);
    private final @NonNull CollisionDomain domain = new CollisionDomain(this);
    private final @NonNull List<Generator> childGenerators;
    private @NonNull List<AbstractAugmentGenerator> augments = List.of();
    private List<GroupingGenerator> groupings;
    private List<AbstractCompositeGenerator<?, ?>> unlinkedComposites = List.of();
    private List<Generator> unlinkedChildren;

    AbstractCompositeGenerator(S statement) {
        super(statement);
        this.childGenerators = this.createChildren((EffectiveStatement<?, ?>)statement);
    }

    AbstractCompositeGenerator(S statement, AbstractCompositeGenerator<?, ?> parent) {
        super(statement, parent);
        this.childGenerators = this.createChildren((EffectiveStatement<?, ?>)statement);
    }

    @Override
    public final Iterator<Generator> iterator() {
        return this.childGenerators.iterator();
    }

    final @NonNull List<AbstractAugmentGenerator> augments() {
        return this.augments;
    }

    final @NonNull List<GroupingGenerator> groupings() {
        return (List)Verify.verifyNotNull(this.groupings, (String)"Groupings not initialized in %s", (Object[])new Object[]{this});
    }

    @Override
    final R createExternalRuntimeType(Type type) {
        return this.createBuilder(this.statement()).populate(new AugmentResolver(), this).build(AbstractCompositeGenerator.verifyGeneratedType(type));
    }

    abstract @NonNull CompositeRuntimeTypeBuilder<S, R> createBuilder(S var1);

    @Override
    final R createInternalRuntimeType(AugmentResolver resolver, S statement, Type type) {
        return this.createBuilder(statement).populate(resolver, this).build(AbstractCompositeGenerator.verifyGeneratedType(type));
    }

    @Override
    final boolean isEmpty() {
        return this.childGenerators.isEmpty();
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findGenerator(List<EffectiveStatement<?, ?>> stmtPath) {
        return this.findGenerator(MatchStrategy.identity(), stmtPath, 0);
    }

    final @Nullable AbstractExplicitGenerator<?, ?> findGenerator(MatchStrategy childStrategy, List<EffectiveStatement<?, ?>> stmtPath, int offset) {
        EffectiveStatement<?, ?> stmt = stmtPath.get(offset);
        AbstractExplicitGenerator<?, ?> ret = childStrategy.findGenerator(stmt, this.childGenerators);
        if (ret != null) {
            int next = offset + 1;
            if (stmtPath.size() == next) {
                return ret;
            }
            if (ret instanceof AbstractCompositeGenerator) {
                AbstractCompositeGenerator composite = (AbstractCompositeGenerator)ret;
                return composite.findGenerator(childStrategy, stmtPath, next);
            }
            return null;
        }
        if (stmt instanceof SchemaTreeEffectiveStatement) {
            for (GroupingGenerator gen : this.groupings) {
                MatchStrategy strat;
                ret = gen.findGenerator(strat = MatchStrategy.grouping(gen), stmtPath, offset);
                if (ret == null) continue;
                return ret;
            }
            MatchStrategy strat = MatchStrategy.augment();
            for (AbstractAugmentGenerator gen : this.augments) {
                ret = gen.findGenerator(strat, stmtPath, offset);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    final @NonNull CollisionDomain domain() {
        return this.domain;
    }

    final void linkUsesDependencies(GeneratorContext context) {
        ArrayList<GroupingGenerator> tmp = new ArrayList<GroupingGenerator>();
        for (EffectiveStatement stmt : this.statement().effectiveSubstatements()) {
            if (!(stmt instanceof UsesEffectiveStatement)) continue;
            UsesEffectiveStatement uses = (UsesEffectiveStatement)stmt;
            GroupingGenerator grouping = context.resolveTreeScoped(GroupingGenerator.class, (QName)uses.argument());
            tmp.add(grouping);
            for (Generator gen : this) {
                if (!(gen instanceof UsesAugmentGenerator)) continue;
                UsesAugmentGenerator usesGen = (UsesAugmentGenerator)gen;
                usesGen.resolveGrouping(uses, grouping);
            }
        }
        this.groupings = List.copyOf(tmp);
    }

    final void linkUsedGroupings(Set<GroupingGenerator> skippedChildren) {
        switch (this.classPlacement()) {
            case NONE: 
            case PHANTOM: {
                break;
            }
            default: {
                for (GroupingGenerator grouping : this.groupings()) {
                    grouping.addUser(this);
                }
            }
        }
        for (Generator child : this.childGenerators) {
            if (child instanceof GroupingGenerator) {
                GroupingGenerator grouping = (GroupingGenerator)child;
                skippedChildren.add(grouping);
                continue;
            }
            if (!(child instanceof AbstractCompositeGenerator)) continue;
            AbstractCompositeGenerator composite = (AbstractCompositeGenerator)child;
            composite.linkUsedGroupings(skippedChildren);
        }
    }

    final void startUsesAugmentLinkage(List<AugmentRequirement> requirements) {
        for (Generator child : this.childGenerators) {
            if (child instanceof UsesAugmentGenerator) {
                UsesAugmentGenerator uses = (UsesAugmentGenerator)child;
                requirements.add(uses.startLinkage());
            }
            if (!(child instanceof AbstractCompositeGenerator)) continue;
            AbstractCompositeGenerator composite = (AbstractCompositeGenerator)child;
            composite.startUsesAugmentLinkage(requirements);
        }
    }

    final void addAugment(AbstractAugmentGenerator augment) {
        if (this.augments.isEmpty()) {
            this.augments = new ArrayList<AbstractAugmentGenerator>(2);
        }
        this.augments.add(Objects.requireNonNull(augment));
    }

    final @NonNull LinkageProgress linkOriginalGeneratorRecursive() {
        Iterator<Generator> it;
        if (this.unlinkedComposites == null) {
            return LinkageProgress.DONE;
        }
        if (this.unlinkedChildren == null) {
            this.unlinkedChildren = this.childGenerators.stream().filter(AbstractExplicitGenerator.class::isInstance).map(child -> (AbstractExplicitGenerator)child).collect(Collectors.toList());
        }
        LinkageProgress progress = LinkageProgress.NONE;
        if (!this.unlinkedChildren.isEmpty()) {
            it = this.unlinkedChildren.iterator();
            while (it.hasNext()) {
                AbstractExplicitGenerator explicit;
                Generator generator = it.next();
                if (!(generator instanceof AbstractExplicitGenerator) || !(explicit = (AbstractExplicitGenerator)generator).linkOriginalGenerator()) continue;
                progress = LinkageProgress.SOME;
                it.remove();
                if (!(explicit instanceof AbstractCompositeGenerator)) continue;
                AbstractCompositeGenerator composite = (AbstractCompositeGenerator)explicit;
                if (this.unlinkedComposites.isEmpty()) {
                    this.unlinkedComposites = new ArrayList();
                }
                this.unlinkedComposites.add(composite);
            }
            if (this.unlinkedChildren.isEmpty()) {
                this.unlinkedChildren = List.of();
            }
        }
        it = this.unlinkedComposites.iterator();
        while (it.hasNext()) {
            LinkageProgress tmp = ((AbstractCompositeGenerator)it.next()).linkOriginalGeneratorRecursive();
            if (tmp != LinkageProgress.NONE) {
                progress = LinkageProgress.SOME;
            }
            if (tmp != LinkageProgress.DONE) continue;
            it.remove();
        }
        if (this.unlinkedChildren.isEmpty() && this.unlinkedComposites.isEmpty()) {
            this.unlinkedComposites = null;
            return LinkageProgress.DONE;
        }
        return progress;
    }

    @Override
    final AbstractCompositeGenerator<S, R> getOriginal() {
        return (AbstractCompositeGenerator)super.getOriginal();
    }

    @Override
    final AbstractCompositeGenerator<S, R> tryOriginal() {
        return (AbstractCompositeGenerator)super.tryOriginal();
    }

    final <X extends EffectiveStatement<?, ?>, Y extends RuntimeType> @Nullable OriginalLink<X, Y> originalChild(QName childQName) {
        QName prevQName;
        AbstractExplicitGenerator<?, ?> found = this.findInferredGenerator(childQName);
        if (found != null) {
            return OriginalLink.partial(found);
        }
        AbstractExplicitGenerator prev = this.previous();
        if (prev != null && (found = prev.findSchemaTreeGenerator(prevQName = childQName.bindTo(prev.getQName().getModule()))) != null) {
            return found.originalLink();
        }
        return null;
    }

    @Override
    final AbstractExplicitGenerator<?, ?> findSchemaTreeGenerator(QName qname) {
        AbstractExplicitGenerator<?, ?> found = super.findSchemaTreeGenerator(qname);
        return found != null ? found : this.findInferredGenerator(qname);
    }

    final @Nullable AbstractAugmentGenerator findAugmentForGenerator(QName qname) {
        for (AbstractAugmentGenerator augment : this.augments) {
            AbstractExplicitGenerator<?, ?> gen = augment.findSchemaTreeGenerator(qname);
            if (gen == null) continue;
            return augment;
        }
        return null;
    }

    final @Nullable GroupingGenerator findGroupingForGenerator(QName qname) {
        for (GroupingGenerator grouping : this.groupings) {
            AbstractExplicitGenerator<?, ?> gen = grouping.findSchemaTreeGenerator(qname.bindTo(((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule()));
            if (gen == null) continue;
            return grouping;
        }
        return null;
    }

    private @Nullable AbstractExplicitGenerator<?, ?> findInferredGenerator(QName qname) {
        AbstractExplicitGenerator<?, ?> gen;
        for (GroupingGenerator grouping : this.groupings) {
            gen = grouping.findSchemaTreeGenerator(qname.bindTo(((QName)((GroupingEffectiveStatement)grouping.statement()).argument()).getModule()));
            if (gen == null) continue;
            return gen;
        }
        for (AbstractAugmentGenerator augment : this.augments) {
            gen = augment.findSchemaTreeGenerator(qname);
            if (gen == null) continue;
            return gen;
        }
        return null;
    }

    final void addUsesInterfaces(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        for (GroupingGenerator grp : this.groupings) {
            builder.addImplementsType((Type)grp.getGeneratedType(builderFactory));
        }
    }

    static final void addAugmentable(GeneratedTypeBuilder builder) {
        builder.addImplementsType((Type)BindingTypes.augmentable((Type)builder));
    }

    final void addGetterMethods(GeneratedTypeBuilder builder, TypeBuilderFactory builderFactory) {
        for (Generator child : this) {
            GeneratedType enclosedType;
            if (child instanceof AbstractExplicitGenerator) {
                AbstractExplicitGenerator explicit = (AbstractExplicitGenerator)child;
                explicit.addAsGetterMethod((GeneratedTypeBuilderBase<?>)builder, builderFactory);
            }
            if ((enclosedType = child.enclosedType(builderFactory)) instanceof GeneratedTransferObject) {
                GeneratedTransferObject gto = (GeneratedTransferObject)enclosedType;
                builder.addEnclosingTransferObject(gto);
                continue;
            }
            if (enclosedType instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)enclosedType;
                builder.addEnumeration(enumeration);
                continue;
            }
            Verify.verify((enclosedType == null ? 1 : 0) != 0, (String)"Unhandled enclosed type %s in %s", (Object)enclosedType, (Object)child);
        }
    }

    private @NonNull List<Generator> createChildren(EffectiveStatement<?, ?> statement) {
        ArrayList tmp = new ArrayList();
        ArrayList<? super AbstractAugmentGenerator> tmpAug = new ArrayList<AbstractAugmentGenerator>();
        block27: for (EffectiveStatement stmt : statement.effectiveSubstatements()) {
            EffectiveStatement effectiveStatement;
            Objects.requireNonNull(stmt);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ActionEffectiveStatement.class, AnydataEffectiveStatement.class, AnyxmlEffectiveStatement.class, CaseEffectiveStatement.class, ChoiceEffectiveStatement.class, ContainerEffectiveStatement.class, FeatureEffectiveStatement.class, GroupingEffectiveStatement.class, IdentityEffectiveStatement.class, InputEffectiveStatement.class, LeafEffectiveStatement.class, LeafListEffectiveStatement.class, ListEffectiveStatement.class, NotificationEffectiveStatement.class, OutputEffectiveStatement.class, RpcEffectiveStatement.class, TypedefEffectiveStatement.class, AugmentEffectiveStatement.class, UsesEffectiveStatement.class, YangDataEffectiveStatement.class}, (Object)effectiveStatement, n)) {
                case 0: {
                    ActionEffectiveStatement action = (ActionEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAugmenting(action)) continue block27;
                    tmp.add(new ActionGenerator(action, this));
                    break;
                }
                case 1: {
                    AnydataEffectiveStatement anydata = (AnydataEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAugmenting(anydata)) continue block27;
                    tmp.add(new OpaqueObjectGenerator.Anydata(anydata, this));
                    break;
                }
                case 2: {
                    AnyxmlEffectiveStatement anyxml = (AnyxmlEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAugmenting(anyxml)) continue block27;
                    tmp.add(new OpaqueObjectGenerator.Anyxml(anyxml, this));
                    break;
                }
                case 3: {
                    CaseEffectiveStatement cast = (CaseEffectiveStatement)effectiveStatement;
                    tmp.add(new CaseGenerator(cast, this));
                    break;
                }
                case 4: {
                    ChoiceEffectiveStatement choice = (ChoiceEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAddedByUses(choice)) continue block27;
                    tmp.add(new ChoiceGenerator(choice, this));
                    break;
                }
                case 5: {
                    ContainerEffectiveStatement container = (ContainerEffectiveStatement)effectiveStatement;
                    if (!AbstractCompositeGenerator.isOriginalDeclaration(container)) continue block27;
                    tmp.add(new ContainerGenerator(container, this));
                    break;
                }
                case 6: {
                    FeatureEffectiveStatement feature = (FeatureEffectiveStatement)effectiveStatement;
                    AbstractCompositeGenerator abstractCompositeGenerator = this;
                    if (!(abstractCompositeGenerator instanceof ModuleGenerator)) continue block27;
                    ModuleGenerator parent = (ModuleGenerator)abstractCompositeGenerator;
                    tmp.add(new FeatureGenerator(feature, parent));
                    break;
                }
                case 7: {
                    GroupingEffectiveStatement grouping = (GroupingEffectiveStatement)effectiveStatement;
                    tmp.add(new GroupingGenerator(grouping, this));
                    break;
                }
                case 8: {
                    IdentityEffectiveStatement identity = (IdentityEffectiveStatement)effectiveStatement;
                    tmp.add(new IdentityGenerator(identity, this));
                    break;
                }
                case 9: {
                    InputEffectiveStatement input = (InputEffectiveStatement)effectiveStatement;
                    tmp.add(new InputGenerator(input, this));
                    break;
                }
                case 10: {
                    LeafEffectiveStatement leaf = (LeafEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAugmenting(leaf)) continue block27;
                    tmp.add(new LeafGenerator(leaf, this));
                    break;
                }
                case 11: {
                    LeafListEffectiveStatement leafList = (LeafListEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAugmenting(leafList)) continue block27;
                    tmp.add(new LeafListGenerator(leafList, this));
                    break;
                }
                case 12: {
                    ListEffectiveStatement list = (ListEffectiveStatement)effectiveStatement;
                    if (!AbstractCompositeGenerator.isOriginalDeclaration(list)) continue block27;
                    ListGenerator listGen = new ListGenerator(list, this);
                    tmp.add(listGen);
                    AbstractExplicitGenerator keyGen = listGen.keyGenerator();
                    if (keyGen == null) continue block27;
                    tmp.add(keyGen);
                    break;
                }
                case 13: {
                    ModuleGenerator module;
                    AbstractCompositeGenerator listGen;
                    AbstractExplicitGenerator keyGen;
                    NotificationEffectiveStatement notification = (NotificationEffectiveStatement)effectiveStatement;
                    if (AbstractCompositeGenerator.isAugmenting(notification)) continue block27;
                    Objects.requireNonNull(this);
                    int n2 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupingGenerator.class, ListGenerator.class, ModuleGenerator.class}, (Object)keyGen, n2)) {
                        case 0: {
                            GroupingGenerator grouping = (GroupingGenerator)keyGen;
                            if (AbstractCompositeGenerator.isAddedByUses(notification)) continue block27;
                            tmp.add(new NotificationBodyGenerator(notification, grouping));
                            break;
                        }
                        case 1: {
                            listGen = (ListGenerator)keyGen;
                            KeyGenerator keyGen2 = ((ListGenerator)listGen).keyGenerator();
                            tmp.add(keyGen2 == null ? new InstanceNotificationGenerator(notification, listGen) : new KeyedListNotificationGenerator(notification, (ListGenerator)listGen, keyGen2));
                            break;
                        }
                        case 2: {
                            module = (ModuleGenerator)keyGen;
                            tmp.add(new NotificationGenerator(notification, module));
                            break;
                        }
                        default: {
                            tmp.add(new InstanceNotificationGenerator(notification, this));
                            break;
                        }
                    }
                    continue block27;
                }
                case 14: {
                    OutputEffectiveStatement output = (OutputEffectiveStatement)effectiveStatement;
                    tmp.add(new OutputGenerator(output, this));
                    break;
                }
                case 15: {
                    RpcEffectiveStatement rpc = (RpcEffectiveStatement)effectiveStatement;
                    AbstractCompositeGenerator listGen = this;
                    if (!(listGen instanceof ModuleGenerator)) continue block27;
                    ModuleGenerator module = (ModuleGenerator)listGen;
                    tmp.add(new RpcGenerator(rpc, module));
                    break;
                }
                case 16: {
                    TypedefEffectiveStatement typedef = (TypedefEffectiveStatement)effectiveStatement;
                    tmp.add(new TypedefGenerator(typedef, this));
                    break;
                }
                case 17: {
                    AugmentEffectiveStatement augment = (AugmentEffectiveStatement)effectiveStatement;
                    AbstractCompositeGenerator abstractCompositeGenerator = this;
                    if (!(abstractCompositeGenerator instanceof ModuleGenerator)) continue block27;
                    ModuleGenerator module = (ModuleGenerator)abstractCompositeGenerator;
                    tmpAug.add(new ModuleAugmentGenerator(augment, module));
                    break;
                }
                case 18: {
                    UsesEffectiveStatement uses = (UsesEffectiveStatement)effectiveStatement;
                    for (EffectiveStatement usesSub : uses.effectiveSubstatements()) {
                        if (!(usesSub instanceof AugmentEffectiveStatement)) continue;
                        AugmentEffectiveStatement usesAug = (AugmentEffectiveStatement)usesSub;
                        tmpAug.add(new UsesAugmentGenerator(usesAug, uses, this));
                    }
                    continue block27;
                }
                case 19: {
                    YangDataEffectiveStatement yangData = (YangDataEffectiveStatement)effectiveStatement;
                    AbstractCompositeGenerator abstractCompositeGenerator = this;
                    if (!(abstractCompositeGenerator instanceof ModuleGenerator)) continue block27;
                    ModuleGenerator moduleGen = (ModuleGenerator)abstractCompositeGenerator;
                    tmp.add(YangDataGenerator.of(yangData, moduleGen));
                    break;
                }
                default: {
                    LOG.trace("Ignoring statement {}", (Object)stmt);
                }
            }
        }
        tmpAug.sort(AbstractAugmentGenerator.COMPARATOR);
        tmp.addAll(tmpAug);
        return List.copyOf(tmp);
    }

    private static boolean isOriginalDeclaration(EffectiveStatement<?, ?> stmt) {
        CopyableNode copyable;
        AddedByUsesAware aware;
        return !(stmt instanceof AddedByUsesAware) || !(aware = (AddedByUsesAware)stmt).isAddedByUses() && (!(aware instanceof CopyableNode) || !(copyable = (CopyableNode)aware).isAugmenting());
    }

    private static boolean isAddedByUses(EffectiveStatement<?, ?> stmt) {
        AddedByUsesAware aware;
        return stmt instanceof AddedByUsesAware && (aware = (AddedByUsesAware)stmt).isAddedByUses();
    }

    private static boolean isAugmenting(EffectiveStatement<?, ?> stmt) {
        CopyableNode copyable;
        return stmt instanceof CopyableNode && (copyable = (CopyableNode)stmt).isAugmenting();
    }
}

