/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.serviceutils.metrics;

import org.immutables.value.Value;
import org.opendaylight.serviceutils.metrics.IDs;
import org.opendaylight.serviceutils.metrics.ImmutableMetricDescriptor;

@Value.Immutable
@Value.Style(stagedBuilder=true)
public abstract class MetricDescriptor {
    public static ImmutableMetricDescriptor.AnchorBuildStage builder() {
        return ImmutableMetricDescriptor.builder();
    }

    public abstract Object anchor();

    public abstract String project();

    public abstract String module();

    public abstract String id();

    @Value.Default
    public String description() {
        return this.id();
    }

    @Value.Check
    protected void check() {
        IDs.checkOnlyLowercaseAZ09(this.project());
        IDs.checkOnlyLowercaseAZ09(this.module());
        IDs.checkOnlyAZ09Underscore(this.id());
    }
}

